package cn.godmao.airserver;

import cn.godmao.netty.ChannelService;
import cn.godmao.netty.handler.IConnect;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.ChannelMatcher;
import io.netty.util.AttributeMap;
import io.netty.util.concurrent.EventExecutor;

import java.util.Collection;
import java.util.function.Function;

public class AirServer<CONN extends IConnect> {
    private final CONN connect;

    public AirServer(CONN connect) {
        this.connect = connect;
    }

    public CONN getConnect() {
        return connect;
    }

    public void start() {
        connect.start();
    }

    public ChannelService getChannelService() {
        return connect.getChannelService();
    }

    public void channelBind(Channel channel, Object id) {
        getChannelService().bind(channel, id);
    }

    public Object getChannelId(AttributeMap attributeMap) {
        return getChannelService().getChannelId(attributeMap);
    }

    public EventExecutor getChannelExecutor(AttributeMap attributeMap) {
        return getChannelService().getChannelExecutor(attributeMap);
    }

    public ChannelFuture send(Object message, ChannelOutboundInvoker channelOutboundInvoker) {
        return connect.getChannelService().writeAndFlush(message, channelOutboundInvoker);
    }

    public ChannelGroupFuture send(Object message) {
        return connect.getChannelService().writeAndFlush(message);
    }

    public ChannelGroupFuture send(Object message, ChannelMatcher matcher) {
        return connect.getChannelService().writeAndFlush(message, matcher);
    }

    public <T> ChannelGroupFuture send(Object message, Function<Channel, T> function, Collection<T> collection) {
        return connect.getChannelService().writeAndFlush(message, function, collection);
    }

    public <T> ChannelGroupFuture send(Object message, Function<Channel, T> function, T... collection) {
        return connect.getChannelService().writeAndFlush(message, function, collection);
    }

}
