/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.airserver.action;

import cn.godmao.airserver.action.annotation.Action;
import cn.godmao.airserver.action.annotation.ActionController;
import cn.godmao.exception.Code;
import cn.godmao.json.JsonUtil;
import cn.godmao.utils.ClassUtil;
import cn.godmao.utils.CollectUtil;
import cn.godmao.utils.ObjectUtil;
import cn.godmao.utils.clazz.MethodAccess;
import cn.hutool.core.lang.ClassScanner;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;

public class ActionHandler {
    public static final DefaultParameterNameDiscoverer defaultParameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private final Collection<Object> beans = new ArrayList<Object>();
    private final Map<String, Set<MethodNode>> actionGroup = new HashMap<String, Set<MethodNode>>();

    public void init(Class<?> mainClass) {
        ClassScanner classScanner = new ClassScanner(mainClass.getPackage().getName(), clazz -> Objects.nonNull(AnnotationUtils.findAnnotation((Class)clazz, ActionController.class)));
        ArrayList<Object> beans = new ArrayList<Object>();
        for (Class clazz2 : classScanner.scan()) {
            ActionController controller = (ActionController)AnnotationUtils.findAnnotation((Class)clazz2, ActionController.class);
            if (null == controller) continue;
            beans.add(ClassUtil.getConstructorAccess((Class)clazz2).newInstance());
        }
        this.init(beans);
    }

    public synchronized void init(Collection<Object> beans) {
        ObjectUtil.checkNotNull(beans, (String)"beans is null");
        this.beans.addAll(beans);
        for (Object bean : this.beans) {
            Class<?> beanClass = bean.getClass();
            List methods = ClassUtil.getMethods((Method[])ClassUtil.getDeclaredMethods(beanClass), (int[])new int[]{2});
            ActionController actionController = (ActionController)AnnotationUtils.findAnnotation(beanClass, ActionController.class);
            if (null == actionController) continue;
            String[] values_actionController = actionController.value();
            for (int i = 0; i < methods.size(); ++i) {
                Method method = (Method)methods.get(i);
                Action action = (Action)AnnotationUtils.findAnnotation((Method)method, Action.class);
                if (null == action) continue;
                Object[] values_action = action.value();
                List valuesAction = CollectUtil.listOf((Object[])values_action);
                for (String value_actionController : values_actionController) {
                    valuesAction.replaceAll(value_action -> value_actionController + value_action);
                }
                String methodName = method.getName();
                Class<?>[] parameterTypes = method.getParameterTypes();
                String[] parameterNames = defaultParameterNameDiscoverer.getParameterNames(method);
                LinkedHashSet<Param> params = new LinkedHashSet<Param>();
                for (int i1 = 0; i1 < parameterTypes.length; ++i1) {
                    Class<?> parameterType = parameterTypes[i1];
                    String parameterName = parameterNames[i1];
                    params.add(new Param(parameterType, parameterName, ObjectUtil.defaultValue(parameterType)));
                }
                MethodNode methodNode = new MethodNode(params, methodName, !method.getReturnType().isAssignableFrom(Void.TYPE), action, bean, i);
                for (String key : valuesAction) {
                    Set methodNodes = this.actionGroup.getOrDefault(key, new HashSet());
                    boolean add = methodNodes.add(methodNode);
                    if (!add) {
                        throw Code.FAIL.exception(beanClass.getSimpleName() + "." + key + "." + methodName + ": \u63a5\u53e3\u91cd\u590d,\u8bf7\u68c0\u67e5!");
                    }
                    this.actionGroup.put(key, methodNodes);
                }
            }
        }
    }

    public Collection<Object> getBeans() {
        return this.beans;
    }

    public MethodNode match(String key) {
        return this.match(key, new HashSet<Param>());
    }

    public MethodNode match(String key, Set<Param> params) {
        Set<MethodNode> methodNodes = this.actionGroup.get(key);
        if (null == methodNodes || methodNodes.isEmpty()) {
            throw Code.FAIL.exception(404, "not found", (Object)key);
        }
        double weight_ = 0.0;
        MethodNode methodNode_ = null;
        for (MethodNode methodNode : methodNodes) {
            double weight = methodNode.match(params);
            if (null != methodNode_ && !(weight > weight_)) continue;
            weight_ = weight;
            methodNode_ = methodNode;
        }
        return methodNode_;
    }

    public static ActionHandler me() {
        return Holder.ME;
    }

    public static class Param {
        private final Class<?> pClass;
        private final Object value;
        private final String name;

        public Param(Class<?> pClass, String name, Object value) {
            this.pClass = pClass;
            this.value = value;
            this.name = name;
        }

        public Param(String name, Object value) {
            this(null != value ? value.getClass() : null, name, value);
        }

        public Class<?> getpClass() {
            return this.pClass;
        }

        public Object getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Param param = (Param)o;
            return Objects.equals(this.pClass, param.pClass) && Objects.equals(this.name, param.name);
        }

        public int hashCode() {
            return Objects.hash(this.pClass, this.name);
        }

        public String toString() {
            return "{name:" + this.name + ",value:" + this.value + "}";
        }
    }

    public static class MethodNode
    extends MethodAccess
    implements Matcher<Set<Param>, Double> {
        private final Set<Param> params;
        private final String methodName;
        private final Action action;
        private final Object bean;
        private final Integer index;
        private final boolean hasReturn;

        public MethodNode(Set<Param> params, String methodName, boolean hasReturn, Action action, Object bean, int index) {
            super(bean);
            this.params = params;
            this.methodName = methodName;
            this.hasReturn = hasReturn;
            this.action = action;
            this.bean = bean;
            this.index = index;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Action getAction() {
            return this.action;
        }

        public Object getBean() {
            return this.bean;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Set<Param> getParams() {
            return this.params;
        }

        public boolean hasReturn() {
            return this.hasReturn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodNode that = (MethodNode)o;
            return Objects.equals(this.params, that.params);
        }

        public int hashCode() {
            return Objects.hash(this.params);
        }

        @Override
        public Double match(Set<Param> paramsThat) {
            Set<Param> paramsThis = this.getParams();
            double weight = 0.0;
            double addweight = Math.abs(paramsThat.size() - this.getParams().size());
            if (addweight == 0.0) {
                addweight = -1.0;
            }
            weight -= addweight;
            for (Param paramThis : paramsThis) {
                Class<?> paramThisClass = paramThis.getpClass();
                String paramThisName = paramThis.getName();
                if (paramsThat.contains(paramThis)) {
                    weight += 3.0;
                    continue;
                }
                if (paramsThat.stream().anyMatch(param -> param.getName().equals(paramThisName))) {
                    weight += 2.0;
                    continue;
                }
                if (!paramsThat.stream().anyMatch(param -> paramThisClass.isAssignableFrom(param.getpClass()))) continue;
                weight += 1.0;
            }
            return weight;
        }

        public Object invoke(Object ... args) {
            return this.invoke(this.index, args);
        }

        public Object invoke(Param ... params) {
            return this.invoke(Arrays.asList(params));
        }

        public Object invoke(Collection<Param> params) {
            Param paramOrig;
            Object[] args = new Object[this.getParams().size()];
            int index = 0;
            HashMap<Integer, Param> paramIndexGroup = new HashMap<Integer, Param>(this.getParams().size());
            for (Param param : this.getParams()) {
                paramIndexGroup.put(index++, param);
            }
            if (!paramIndexGroup.isEmpty()) {
                Map paramHashGroup = CollectUtil.toMap(params, Param::hashCode);
                for (Integer paramIndex : paramIndexGroup.keySet()) {
                    paramOrig = (Param)paramIndexGroup.get(paramIndex);
                    Param paramByHash = (Param)paramHashGroup.get(paramOrig.hashCode());
                    if (null == paramByHash) continue;
                    args[paramIndex.intValue()] = paramByHash.getValue();
                    paramIndexGroup.remove(paramIndex);
                }
            }
            if (!paramIndexGroup.isEmpty()) {
                Map paramNameGroup = CollectUtil.toMap(params, Param::getName);
                for (Integer paramIndex : paramIndexGroup.keySet()) {
                    paramOrig = (Param)paramIndexGroup.get(paramIndex);
                    Param paramByName = (Param)paramNameGroup.get(paramOrig.getName());
                    if (null == paramByName) continue;
                    args[paramIndex.intValue()] = JsonUtil.parse((Object)paramByName.getValue(), paramOrig.getpClass());
                    paramIndexGroup.remove(paramIndex);
                }
            }
            if (!paramIndexGroup.isEmpty()) {
                Map paramClassGroup = CollectUtil.toMap(params, Param::getpClass);
                for (Integer paramIndex : paramIndexGroup.keySet()) {
                    paramOrig = (Param)paramIndexGroup.get(paramIndex);
                    Param paramByClass = (Param)paramClassGroup.get(paramOrig.getpClass());
                    if (null == paramByClass) continue;
                    args[paramIndex.intValue()] = paramByClass.getValue();
                    paramIndexGroup.remove(paramIndex);
                }
            }
            if (!paramIndexGroup.isEmpty()) {
                for (Integer n : paramIndexGroup.keySet()) {
                    Param paramOrig2 = (Param)paramIndexGroup.get(n);
                    args[n.intValue()] = ObjectUtil.defaultValue(paramOrig2.getpClass());
                }
            }
            return this.invoke(args);
        }
    }

    private static class Holder {
        static final ActionHandler ME = new ActionHandler();

        private Holder() {
        }
    }

    @FunctionalInterface
    private static interface Matcher<T, R> {
        public R match(T var1);
    }
}

