/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.airserver.action;

import cn.godmao.airserver.action.annotation.Action;
import cn.godmao.airserver.action.annotation.ActionController;
import cn.godmao.airserver.common.Code;
import cn.godmao.json.JsonUtil;
import cn.godmao.utils.ClassUtil;
import cn.godmao.utils.CollectUtil;
import cn.godmao.utils.ObjectUtil;
import cn.godmao.utils.clazz.MethodAccess;
import cn.hutool.core.lang.ClassScanner;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;

public class ActionHandler {
    public static final DefaultParameterNameDiscoverer defaultParameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Collection<Object> beans = new ArrayList<Object>();
    private final Map<String, Set<MethodNode>> actionGroup = new HashMap<String, Set<MethodNode>>();
    private boolean init = false;

    public void init(Class<?> mainClass) {
        ClassScanner classScanner = new ClassScanner(mainClass.getPackage().getName(), clazz -> Objects.nonNull(AnnotationUtils.findAnnotation((Class)clazz, ActionController.class)));
        ArrayList<Object> beans = new ArrayList<Object>();
        for (Class clazz2 : classScanner.scan()) {
            ActionController controller = (ActionController)AnnotationUtils.findAnnotation((Class)clazz2, ActionController.class);
            if (null == controller) continue;
            beans.add(ClassUtil.getConstructorAccess((Class)clazz2).newInstance());
        }
        this.init(beans);
    }

    public synchronized void init(Collection<Object> beans) {
        if (this.init) {
            this.log.warn("\u5df2\u7ecf\u52a0\u8f7d {}", (Object)this.getClass().getName());
            return;
        }
        if (null == beans) {
            throw new NullPointerException("beanFactory is null");
        }
        this.beans.addAll(beans);
        for (Object bean : this.beans) {
            Class<?> beanClass = bean.getClass();
            List methods = ClassUtil.getMethods((Method[])ClassUtil.getDeclaredMethods(beanClass), (int[])new int[]{2});
            ActionController actionController = (ActionController)AnnotationUtils.findAnnotation(beanClass, ActionController.class);
            if (null == actionController) continue;
            String[] values_actionController = actionController.value();
            for (int i = 0; i < methods.size(); ++i) {
                Method method = (Method)methods.get(i);
                Action action = (Action)AnnotationUtils.findAnnotation((Method)method, Action.class);
                if (null == action) continue;
                Object[] values_action = action.value();
                List valuesAction = CollectUtil.listOf((Object[])values_action);
                for (String value_actionController : values_actionController) {
                    valuesAction.replaceAll(value_action -> value_actionController + value_action);
                }
                String methodName = method.getName();
                Class<?>[] parameterTypes = method.getParameterTypes();
                String[] parameterNames = defaultParameterNameDiscoverer.getParameterNames(method);
                LinkedHashSet<Param> params = new LinkedHashSet<Param>();
                for (int i1 = 0; i1 < parameterTypes.length; ++i1) {
                    Class<?> parameterType = parameterTypes[i1];
                    String parameterName = parameterNames[i1];
                    params.add(new Param(parameterType, parameterName, ObjectUtil.defaultValue(parameterType)));
                }
                MethodNode methodNode = new MethodNode(params, methodName, !method.getReturnType().isAssignableFrom(Void.TYPE), action, bean, i);
                for (String key : valuesAction) {
                    Set methodNodes = this.actionGroup.getOrDefault(key, new HashSet());
                    boolean add = methodNodes.add(methodNode);
                    if (!add) {
                        throw Code.FAIL.exception(beanClass.getSimpleName() + "." + key + "." + methodName + ": \u63a5\u53e3\u91cd\u590d,\u8bf7\u68c0\u67e5!");
                    }
                    this.actionGroup.put(key, methodNodes);
                }
            }
        }
        this.init = true;
    }

    public Collection<Object> getBeans() {
        return this.beans;
    }

    public Set<Param> getParm(Object object) {
        HashSet<Param> params;
        block3: {
            block2: {
                params = new HashSet<Param>();
                if (!(object instanceof Collection)) break block2;
                for (Object o : (Collection)object) {
                    if (!(o instanceof Param)) continue;
                    params.add((Param)o);
                }
                break block3;
            }
            if (!(object instanceof Map)) break block3;
            Map map = (Map)object;
            for (Object key : map.keySet()) {
                params.add(new Param(String.valueOf(key), map.get(key)));
            }
        }
        return params;
    }

    public MethodNodeMatcher match(String key, Set<Param> params) {
        Set<MethodNode> methodNodes = this.actionGroup.get(key);
        if (null == methodNodes || methodNodes.isEmpty()) {
            throw Code.FAIL.exception(404, "not found", key);
        }
        MethodNodeMatcher methodNodeMatcher = null;
        for (MethodNode methodNode : methodNodes) {
            MethodNodeMatcher methodNodeMatcher_ = methodNode.match(params);
            if (null != methodNodeMatcher && !(methodNodeMatcher.getWeight() < methodNodeMatcher_.getWeight())) continue;
            methodNodeMatcher = methodNodeMatcher_;
        }
        return methodNodeMatcher;
    }

    private static Object invoke(MethodNodeMatcher methodNodeMatcher, Set<Param> params) {
        Map paramGroup = CollectUtil.toMap(params, Param::getParamName);
        MethodNode methodNode = methodNodeMatcher.getMethodNode();
        Set<Param> paramsOrig = methodNode.getParams();
        Object[] args = new Object[paramsOrig.size()];
        int index = 0;
        for (Param paramOrig : paramsOrig) {
            String paramOrigName = paramOrig.getParamName();
            Class<?> paramOrigClass = paramOrig.getParamClass();
            Param param = (Param)paramGroup.get(paramOrigName);
            if (null != param) {
                Object paramValue = param.getParamValue();
                Object parse = JsonUtil.parse((Object)paramValue, paramOrigClass);
                paramGroup.remove(paramOrigName);
                args[index] = parse;
            } else {
                args[index] = ObjectUtil.defaultValue(paramOrigClass);
            }
            ++index;
        }
        return methodNode.invoke(args);
    }

    public static ActionHandler me() {
        return Holder.ME;
    }

    public static class MethodNodeMatcher {
        private final double weight;
        private final MethodNode methodNode;

        public MethodNodeMatcher(double weight, MethodNode methodNode) {
            this.weight = weight;
            this.methodNode = methodNode;
        }

        public double getWeight() {
            return this.weight;
        }

        public MethodNode getMethodNode() {
            return this.methodNode;
        }

        public Object invoke(Set<Param> params) {
            return ActionHandler.invoke(this, params);
        }
    }

    public static class Param {
        private final Class<?> paramClass;
        private final Object paramValue;
        private final String paramName;

        public Param(Class<?> paramClass, String paramName, Object paramValue) {
            this.paramClass = paramClass;
            this.paramValue = paramValue;
            this.paramName = paramName;
        }

        public Param(String paramName, Object paramValue) {
            this(paramValue.getClass(), paramName, paramValue);
        }

        public Class<?> getParamClass() {
            return this.paramClass;
        }

        public Object getParamValue() {
            return this.paramValue;
        }

        public String getParamName() {
            return this.paramName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Param param = (Param)o;
            return Objects.equals(this.paramClass, param.paramClass) && Objects.equals(this.paramName, param.paramName);
        }

        public int hashCode() {
            return Objects.hash(this.paramClass, this.paramName);
        }
    }

    public static class MethodNode
    extends MethodAccess
    implements Matcher<Set<Param>, MethodNodeMatcher> {
        private final Set<Param> params;
        private final String methodName;
        private final Action action;
        private final Object bean;
        private final Integer index;
        private final boolean hasReturn;

        public MethodNode(Set<Param> params, String methodName, boolean hasReturn, Action action, Object bean, int index) {
            super(bean);
            this.params = params;
            this.methodName = methodName;
            this.hasReturn = hasReturn;
            this.action = action;
            this.bean = bean;
            this.index = index;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Action getAction() {
            return this.action;
        }

        public Object getBean() {
            return this.bean;
        }

        public Integer getIndex() {
            return this.index;
        }

        public Set<Param> getParams() {
            return this.params;
        }

        public boolean hasReturn() {
            return this.hasReturn;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodNode that = (MethodNode)o;
            return Objects.equals(this.params, that.params);
        }

        public int hashCode() {
            return Objects.hash(this.params);
        }

        public Object invoke(Object ... args) {
            return this.invoke(this.index, args);
        }

        @Override
        public MethodNodeMatcher match(Set<Param> paramsThat) {
            Set<Param> paramsThis = this.getParams();
            double weight = 0.0;
            double addweight = Math.abs(paramsThat.size() - this.getParams().size());
            if (addweight == 0.0) {
                addweight = -1.0;
            }
            weight -= addweight;
            for (Param paramThis : paramsThis) {
                Class<?> paramThisClass = paramThis.getParamClass();
                String paramThisName = paramThis.getParamName();
                if (paramsThat.contains(paramThis)) {
                    weight += 3.0;
                    continue;
                }
                if (paramsThat.stream().anyMatch(param -> param.getParamName().equals(paramThisName))) {
                    weight += 2.0;
                    continue;
                }
                if (!paramsThat.stream().anyMatch(param -> paramThisClass.isAssignableFrom(param.getParamClass()))) continue;
                weight += 1.0;
            }
            return new MethodNodeMatcher(weight, this);
        }
    }

    private static class Holder {
        static final ActionHandler ME = new ActionHandler();

        private Holder() {
        }
    }

    @FunctionalInterface
    private static interface Matcher<T, R> {
        public R match(T var1);
    }
}

