package cn.godmao.airserver.demo;


import cn.godmao.getty.client.AbstractClient;

public class AirClient extends AbstractClient {


    public AirClient(String uri) {
        super(uri);
    }

    @Override
    public void onOpen() {
        log.info("连接成功 {}", getChannelId());

    }

    @Override
    public void onClose() {
        log.info("连接断开 {}", getChannelId());
    }

    @Override
    public void onError(Throwable throwable) {
        log.error("连接异常 " + getChannelId(), throwable);
    }

    @Override
    public void onMessage(Object message) {
        System.out.println(message);
    }
}
