package cn.godmao.airserver.action;

import cn.godmao.airserver.action.annotation.Action;
import cn.godmao.airserver.action.annotation.ActionController;
import cn.godmao.airserver.common.Code;
import cn.godmao.json.JsonUtil;
import cn.godmao.utils.ClassUtil;
import cn.godmao.utils.CollectUtil;
import cn.godmao.utils.ObjectUtil;
import cn.godmao.utils.clazz.MethodAccess;
import cn.hutool.core.lang.ClassScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.*;

public class ActionHandler {
    public static final DefaultParameterNameDiscoverer defaultParameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Collection<Object> beans;
    private final Map<String, Set<MethodNode>> actionGroup;
    private boolean init;

    public void init(Class<?> mainClass) {
        ClassScanner classScanner = new ClassScanner(mainClass.getPackage().getName(), clazz -> Objects.nonNull(AnnotationUtils.findAnnotation(clazz, ActionController.class)));
        Collection<Object> beans = new ArrayList<>();
        for (Class<?> clazz : classScanner.scan()) {
            ActionController controller = AnnotationUtils.findAnnotation(clazz, ActionController.class);
            if (null == controller) {
                continue;
            }
            beans.add(ClassUtil.getConstructorAccess(clazz).newInstance());
        }
        this.init(beans);
    }

    public synchronized void init(Collection<Object> beans) {
        if (init) {
            log.warn("已经加载 {}", this.getClass().getName());
            return;
        }

        if (null == beans) {
            throw new NullPointerException("beanFactory is null");
        }
        this.beans.addAll(beans);
        for (Object bean : this.beans) {
            Class<?> beanClass = bean.getClass();
            List<Method> methods = ClassUtil.getMethods(ClassUtil.getDeclaredMethods(beanClass), Modifier.PRIVATE);

            ActionController actionController = AnnotationUtils.findAnnotation(beanClass, ActionController.class);
            if (null == actionController) {
                continue;
            }
            final String[] values_actionController = actionController.value();
            for (int i = 0; i < methods.size(); i++) {
                Method method = methods.get(i);
                Action action = AnnotationUtils.findAnnotation(method, Action.class);
                if (null == action) {
                    continue;
                }
                final String[] values_action = action.value();
                List<String> valuesAction = CollectUtil.listOf(values_action);
                for (String value_actionController : values_actionController) {
                    valuesAction.replaceAll(value_action -> value_actionController + value_action);
                }

                String methodName = method.getName();
                Class<?>[] parameterTypes = method.getParameterTypes();
                String[] parameterNames = defaultParameterNameDiscoverer.getParameterNames(method);

                Set<Param> params = new LinkedHashSet<>();
                for (int i1 = 0; i1 < parameterTypes.length; i1++) {
                    Class<?> parameterType = parameterTypes[i1];
                    String parameterName = parameterNames[i1];
                    params.add(new Param(parameterType, parameterName, ObjectUtil.defaultValue(parameterType)));
                }
                MethodNode methodNode = new MethodNode(params, methodName, !method.getReturnType().isAssignableFrom(void.class), action, bean, i);
                for (String key : valuesAction) {
                    Set<MethodNode> methodNodes = actionGroup.getOrDefault(key, new HashSet<>());
                    boolean add = methodNodes.add(methodNode);
                    if (!add) {
                        throw Code.FAIL.exception(beanClass.getSimpleName() + "." + key + "." + methodName + ": 接口重复,请检查!");
                    }
                    actionGroup.put(key, methodNodes);
                }
            }
        }

        //
        init = true;
    }
    public Collection<Object> getBeans() {
        return beans;
    }


    public Set<ActionHandler.Param> getParm(Object object) {
        final Set<ActionHandler.Param> params = new HashSet<>();
        if (object instanceof Collection<?>) {
            for (Object o : (Collection<?>) object) {
                if (o instanceof ActionHandler.Param) {
                    params.add((ActionHandler.Param) o);
                }
            }
        } else if (object instanceof Map<?, ?>) {
            Map<?, ?> map = (Map<?, ?>) object;
            for (Object key : map.keySet()) {
                params.add(new ActionHandler.Param(String.valueOf(key), map.get(key)));
            }
        }
        return params;
    }

    public MethodNodeMatcher match(String key, Set<Param> params) {
        Set<MethodNode> methodNodes = actionGroup.get(key);
        if (null == methodNodes || methodNodes.isEmpty()) {
            throw Code.FAIL.exception(404, "not found", key);
        }
        MethodNodeMatcher methodNodeMatcher = null;
        for (MethodNode methodNode : methodNodes) {
            MethodNodeMatcher methodNodeMatcher_ = methodNode.match(params);
            if (null == methodNodeMatcher || methodNodeMatcher.getWeight() < methodNodeMatcher_.getWeight()) {
                methodNodeMatcher = methodNodeMatcher_;
            }
        }
        return methodNodeMatcher;
    }


    public static class Param {
        private final Class<?> paramClass;
        private final Object paramValue;
        private final String paramName;

        public Param(Class<?> paramClass, String paramName, Object paramValue) {
            this.paramClass = paramClass;
            this.paramValue = paramValue;
            this.paramName = paramName;
        }

        public Param(String paramName, Object paramValue) {
            this(paramValue.getClass(), paramName, paramValue);
        }

        public Class<?> getParamClass() {
            return paramClass;
        }

        public Object getParamValue() {
            return paramValue;
        }

        public String getParamName() {
            return paramName;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            Param param = (Param) o;
            return Objects.equals(paramClass, param.paramClass) && Objects.equals(paramName, param.paramName);
        }

        @Override
        public int hashCode() {
            return Objects.hash(paramClass, paramName);
        }

    }


    @FunctionalInterface
    private interface Matcher<T, R> {
        R match(T t);
    }

    public static class MethodNodeMatcher {
        private final double weight;
        private final MethodNode methodNode;

        public MethodNodeMatcher(double weight, MethodNode methodNode) {
            this.weight = weight;
            this.methodNode = methodNode;
        }

        public double getWeight() {
            return weight;
        }

        public MethodNode getMethodNode() {
            return methodNode;
        }

        public Object invoke(Set<Param> params) {
            return ActionHandler.invoke(this, params);
        }
    }

    private static Object invoke(MethodNodeMatcher methodNodeMatcher, Set<Param> params) {
        Map<String, Param> paramGroup = CollectUtil.toMap(params, Param::getParamName);
        MethodNode methodNode = methodNodeMatcher.getMethodNode();
        Set<Param> paramsOrig = methodNode.getParams();

        Object[] args = new Object[paramsOrig.size()];

        int index = 0;
        for (Param paramOrig : paramsOrig) {
            String paramOrigName = paramOrig.getParamName();
            Class<?> paramOrigClass = paramOrig.getParamClass();
            Param param = paramGroup.get(paramOrigName);
            if (null != param) {
                Object paramValue = param.getParamValue();
                Object parse = JsonUtil.parse(paramValue, paramOrigClass);
                paramGroup.remove(paramOrigName);
                args[index] = parse;
            } else {
                args[index] = ObjectUtil.defaultValue(paramOrigClass);
            }
            index++;
        }

//        if (noMatchParamIndexs.size() == 1) {
//            Object obj;
//            Integer noMatchParamIndex = noMatchParamIndexs.get(0);
//            String paramename = paramenames.get(noMatchParamIndex);
//            Class<?> parametype = parameters.get(paramename);
//            if (paramGroup.size() == 1) {
//                String key = new ArrayList<>(paramGroup.keySet()).get(0);
//                Object value = paramGroup.get(key);
//                if (null != value && parametype.isAssignableFrom(value.getClass())) {
//                    obj = paramGroup.getObject(key, parametype);
//                } else {
//                    obj = paramGroup.toJavaObject(parametype);
//                }
//            } else {
//                obj = paramGroup.toJavaObject(parametype);
//            }
//            paramValues[noMatchParamIndex] = obj;
//        } else {
//            for (Integer noMatchParamIndex : noMatchParamIndexs) {
//                String paramename = paramenames.get(noMatchParamIndex);
//                Class<?> parametype = parameters.get(paramename);
//                paramValues[noMatchParamIndex] = ObjectUtil.defaultValue(parametype);
//            }
//        }
//
//        // todo

        return methodNode.invoke(args);
    }


    public static class MethodNode extends MethodAccess implements Matcher<Set<Param>, MethodNodeMatcher> {
        private final Set<Param> params;
        private final String methodName;
        private final Action action;
        private final Object bean;
        private final Integer index;
        private final boolean hasReturn;

        public MethodNode(Set<Param> params, String methodName, boolean hasReturn, Action action, Object bean, int index) {
            super(bean);
            this.params = params;
            this.methodName = methodName;
            this.hasReturn = hasReturn;
            this.action = action;
            this.bean = bean;
            this.index = index;
        }

        public String getMethodName() {
            return methodName;
        }

        public Action getAction() {
            return action;
        }

        public Object getBean() {
            return bean;
        }

        public Integer getIndex() {
            return index;
        }

        public Set<Param> getParams() {
            return params;
        }

        public boolean hasReturn() {
            return hasReturn;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            MethodNode that = (MethodNode) o;
            return Objects.equals(params, that.params);
        }

        @Override
        public int hashCode() {
            return Objects.hash(params);
        }

        public Object invoke(Object... args) {
            return invoke(index, args);
        }

        @Override
        public MethodNodeMatcher match(Set<Param> paramsThat) {
            Set<Param> paramsThis = getParams();

            double weight = 0.0d;
            //  根据参数长度加权重
            double addweight = Math.abs(paramsThat.size() - getParams().size());
            if (addweight == 0) {
                addweight = -1;
            }
            weight = weight - addweight;

            // 根据参数名加权重 + 根据参数类型加权重
            for (Param paramThis : paramsThis) {
                final Class<?> paramThisClass = paramThis.getParamClass();
                final String paramThisName = paramThis.getParamName();

                if (paramsThat.contains(paramThis)) {
                    // +3
                    weight += 3.0d;
                } else if (paramsThat.stream().anyMatch(param -> param.getParamName().equals(paramThisName))) {
                    // +2
                    weight += 2.0d;
                } else if (paramsThat.stream().anyMatch(param -> paramThisClass.isAssignableFrom(param.getParamClass()))) {
                    // +1
                    weight += 1.0d;
                }
            }

            return new MethodNodeMatcher(weight, this);
        }
    }

    public ActionHandler() {
        this.beans = new ArrayList<>();
        this.actionGroup = new HashMap<>();
        this.init = false;
    }

    public static ActionHandler me() {
        return Holder.ME;
    }


    private static class Holder {
        static final ActionHandler ME = new ActionHandler();
    }

}
