/*
 * Decompiled with CFR 0.152.
 */
package cn.godmao.airserver;

import cn.godmao.airserver.Message;
import cn.godmao.airserver.action.ActionHandler;
import cn.godmao.exception.IException;
import cn.godmao.netty.server.AbstractServer;
import com.alibaba.fastjson2.JSON;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundInvoker;
import io.netty.util.AttributeMap;
import io.netty.util.concurrent.Future;
import java.util.HashSet;

public class DefaultServer
extends AbstractServer {
    public DefaultServer(int port) {
        super(port);
    }

    public void onOpen(ChannelHandlerContext ctx) {
        this.log.info("\u8fde\u63a5\u6210\u529f: |{}", (Object)ctx.channel().id());
    }

    public void onClose(ChannelHandlerContext ctx) {
        this.log.info("\u8fde\u63a5\u5173\u95ed: |{}", (Object)ctx.channel().id());
    }

    public void onError(ChannelHandlerContext ctx, Throwable throwable) {
        this.log.warn("\u8fde\u63a5\u5f02\u5e38: |" + ctx.channel().id(), throwable);
    }

    public void onMessage(ChannelHandlerContext ctx, Object message_) {
        Message message = (Message)message_;
        ActionHandler.MethodNode methodNode = ActionHandler.me().match(message.getPath(), message.getParams());
        HashSet<ActionHandler.Param> params = new HashSet<ActionHandler.Param>(message.getParams());
        params.add(new ActionHandler.Param("path", message.getPath()));
        params.add(new ActionHandler.Param("ctx", ctx));
        params.add(new ActionHandler.Param("channel", ctx.channel()));
        params.add(new ActionHandler.Param("id", this.getChannelService().getChannelId((AttributeMap)ctx)));
        if (null == methodNode) {
            this.log.warn("\u672a\u77e5\u6d88\u606f: {}", message_);
            return;
        }
        Future submit = this.getChannelService().getChannelExecutor((AttributeMap)ctx).submit(() -> methodNode.invoke(params));
        submit.addListener(future -> {
            if (future.isSuccess()) {
                if (methodNode.hasReturn()) {
                    this.getChannelService().writeAndFlush((ChannelOutboundInvoker)ctx, (Object)new Message(message.getPath(), new ActionHandler.Param("result", JSON.toJSON((Object)future.getNow()))));
                }
            } else {
                Object e_data;
                int e_code;
                Throwable cause = future.cause();
                if (cause.getCause() instanceof IException) {
                    e_code = ((IException)cause.getCause()).getCode();
                    e_data = ((IException)cause.getCause()).getData();
                } else if (cause instanceof IException) {
                    e_code = ((IException)cause).getCode();
                    e_data = ((IException)cause).getData();
                } else {
                    this.log.error("SYSTEM ERROR", cause);
                    return;
                }
                this.getChannelService().writeAndFlush((ChannelOutboundInvoker)ctx, (Object)new Message(message.getPath(), new ActionHandler.Param("code", e_code), new ActionHandler.Param("data", JSON.toJSON((Object)e_data))));
            }
        });
    }
}

