package cn.godmao.airserver;

import cn.godmao.airserver.action.ActionHandler;
import cn.godmao.airserver.message.Message;
import cn.godmao.getty.server.AbstractServer;
import cn.godmao.getty.server.DefaultChannel;
import cn.godmao.getty.server.ServerConfig;

import java.util.Set;

public class AirServer extends AbstractServer<DefaultChannel> {

    final ActionHandler actionHandler = ActionHandler.me();

    public AirServer(ServerConfig serverConfig) {
        super(serverConfig);
    }

    public AirServer() {
        super();
    }

    public AirServer(Integer port) {
        super(port);
    }

    @Override
    public void onOpen(DefaultChannel channel) {
        log.info("连接成功 {}", channel.getId());
    }

    @Override
    public void onClose(DefaultChannel channel) {
        log.info("连接断开 {}", channel.getId());
    }

    @Override
    public void onError(DefaultChannel channel, Throwable throwable) {
        log.error("连接异常 " + channel.getId(), throwable);
    }

    @Override
    public void onMessage(DefaultChannel channel, Object object) {
        if (!(object instanceof Message)) {
            log.warn("未知消息 {}", object);
            return;
        }
        
        Message message = (Message) object;
        final String protocol = message.getProtocol();
        final Object body = message.getBody();
        try {
            Set<ActionHandler.Param> params = actionHandler.getParm(object);
            params.add(new ActionHandler.Param("body", body));
            params.add(new ActionHandler.Param("message", message));
            params.add(new ActionHandler.Param("channel", channel));
            ActionHandler.MethodNodeMatcher methodNodeMatcher = actionHandler.match(protocol, params);
            Object result = methodNodeMatcher.invoke(params);
            if (methodNodeMatcher.getMethodNode().hasReturn()) {
//                    channel.send(protocol, Code.SUCCESS.getCode(), result);
            }
        } catch (Exception e) {
            //                    channel.send(protocol, Code.SUCCESS.getCode(), result);
        }
    }
}
