/*
 * Decompiled with CFR 0.152.
 */
package cn.gjsm.miukoo.utils;

import cn.gjsm.api.openai.OpenAiClient;
import cn.gjsm.api.openai.OpenAiClientFactory;
import cn.gjsm.api.pojo.completion.CompletionChoice;
import cn.gjsm.api.pojo.completion.CompletionRequest;
import cn.gjsm.api.pojo.completion.CompletionResponse;
import cn.gjsm.miukoo.pojos.OpenAi;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.springframework.util.StringUtils;

public class OpenAiUtils {
    public static final Map<String, OpenAi> PARMS = new HashMap<String, OpenAi>();
    public static String OPENAPI_TOKEN;
    public static Integer TIMEOUT;

    public static List<CompletionChoice> getAiResult(OpenAi openAi, String prompt) {
        if (TIMEOUT == null || TIMEOUT < 1000) {
            TIMEOUT = 3000;
        }
        OpenAiClient service = OpenAiClientFactory.createClient((String)OPENAPI_TOKEN);
        CompletionRequest.CompletionRequestBuilder builder = (CompletionRequest.CompletionRequestBuilder)((CompletionRequest.CompletionRequestBuilder)((CompletionRequest.CompletionRequestBuilder)((CompletionRequest.CompletionRequestBuilder)((CompletionRequest.CompletionRequestBuilder)CompletionRequest.builder().model(openAi.getModel()).prompt(Arrays.asList(prompt)).temperature(openAi.getTemperature().doubleValue())).maxTokens(1000)).topP(openAi.getTopP().doubleValue())).frequencyPenalty(openAi.getFrequencyPenalty().doubleValue())).presencePenalty(openAi.getPresencePenalty().doubleValue());
        if (!StringUtils.isEmpty((Object)openAi.getStop())) {
            builder.stop(Arrays.asList(openAi.getStop().split(",")));
        }
        CompletionRequest completionRequest = builder.build();
        try {
            return ((CompletionResponse)service.callCompletion(completionRequest).execute().body()).getChoices();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<CompletionChoice> getQuestionAnswer(String question) {
        OpenAi openAi = PARMS.get("OpenAi01");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), question));
    }

    public static List<CompletionChoice> getGrammarCorrection(String text) {
        OpenAi openAi = PARMS.get("OpenAi02");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getSummarize(String text) {
        OpenAi openAi = PARMS.get("OpenAi03");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getOpenAiApi(String text) {
        OpenAi openAi = PARMS.get("OpenAi04");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getTextToCommand(String text) {
        OpenAi openAi = PARMS.get("OpenAi05");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getTranslatesLanguages(String text, String translatesLanguages) {
        if (StringUtils.isEmpty((Object)translatesLanguages)) {
            translatesLanguages = "  1. French, 2. Spanish and 3. English";
        }
        OpenAi openAi = PARMS.get("OpenAi06");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), translatesLanguages, text));
    }

    public static List<CompletionChoice> getStripeApi(String text) {
        OpenAi openAi = PARMS.get("OpenAi07");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getStripeApi(String databaseType, List<String> tables, String text, String sqlType) {
        OpenAi openAi = PARMS.get("OpenAi08");
        StringJoiner joiner = new StringJoiner("\n");
        for (int i = 0; i < tables.size(); ++i) {
            joiner.add("# " + tables);
        }
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), databaseType, joiner.toString(), text, sqlType));
    }

    public static List<CompletionChoice> getUnstructuredData(String text) {
        OpenAi openAi = PARMS.get("OpenAi09");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getTextCategory(String text) {
        OpenAi openAi = PARMS.get("OpenAi10");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getCodeExplain(String codeType, String code) {
        OpenAi openAi = PARMS.get("OpenAi11");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), codeType, code));
    }

    public static List<CompletionChoice> getTextEmoji(String text) {
        OpenAi openAi = PARMS.get("OpenAi12");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getTimeComplexity(String code) {
        OpenAi openAi = PARMS.get("OpenAi13");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), code));
    }

    public static List<CompletionChoice> getTranslateProgramming(String fromLanguage, String toLanguage, String code) {
        OpenAi openAi = PARMS.get("OpenAi14");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), fromLanguage, toLanguage, fromLanguage, code, toLanguage));
    }

    public static List<CompletionChoice> getBatchTweetClassifier(List<String> texts) {
        OpenAi openAi = PARMS.get("OpenAi15");
        StringJoiner stringJoiner = new StringJoiner("\n");
        for (int i = 0; i < texts.size(); ++i) {
            stringJoiner.add(i + 1 + ". " + texts.get(i));
        }
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), stringJoiner.toString()));
    }

    public static List<CompletionChoice> getExplainCOde(String code) {
        OpenAi openAi = PARMS.get("OpenAi16");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), code));
    }

    public static List<CompletionChoice> getTextKeywords(String text) {
        OpenAi openAi = PARMS.get("OpenAi17");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getFactualAnswering(String text) {
        OpenAi openAi = PARMS.get("OpenAi18");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getAd(String text) {
        OpenAi openAi = PARMS.get("OpenAi19");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getProductName(String productDescription, String seedWords) {
        OpenAi openAi = PARMS.get("OpenAi20");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), productDescription, seedWords));
    }

    public static List<CompletionChoice> getProductName(String text) {
        OpenAi openAi = PARMS.get("OpenAi21");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getBugFixer(String codeType, String code) {
        OpenAi openAi = PARMS.get("OpenAi22");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), codeType, code, codeType));
    }

    public static List<CompletionChoice> getFillData(int rows, String headers) {
        OpenAi openAi = PARMS.get("OpenAi23");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), rows, headers));
    }

    public static List<CompletionChoice> getProgrammingLanguageChatbot(String question, String programmingLanguages) {
        OpenAi openAi = PARMS.get("OpenAi24");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), question, programmingLanguages));
    }

    public static List<CompletionChoice> getMLChatbot(String question) {
        OpenAi openAi = PARMS.get("OpenAi25");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), question));
    }

    public static List<CompletionChoice> getListMaker(String text) {
        OpenAi openAi = PARMS.get("OpenAi26");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getTweetClassifier(String text) {
        OpenAi openAi = PARMS.get("OpenAi27");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getAirportCodeExtractor(String text) {
        OpenAi openAi = PARMS.get("OpenAi28");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getSQL(String text) {
        OpenAi openAi = PARMS.get("OpenAi29");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getExtractContactInformation(String extractContent, String text) {
        OpenAi openAi = PARMS.get("OpenAi30");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), extractContent, text));
    }

    public static List<CompletionChoice> getTransformationCode(String fromCodeType, String toCodeType, String code) {
        OpenAi openAi = PARMS.get("OpenAi31");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), fromCodeType, toCodeType, fromCodeType, code, toCodeType));
    }

    public static List<CompletionChoice> getFriendChat(String question) {
        OpenAi openAi = PARMS.get("OpenAi32");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), question));
    }

    public static List<CompletionChoice> getMoodToColor(String text) {
        OpenAi openAi = PARMS.get("OpenAi33");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getCodeDocument(String codeType, String code) {
        OpenAi openAi = PARMS.get("OpenAi34");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), codeType, code));
    }

    public static List<CompletionChoice> getCreateAnalogies(String text) {
        OpenAi openAi = PARMS.get("OpenAi35");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getCodeLine(String codeType, String code) {
        OpenAi openAi = PARMS.get("OpenAi36");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), codeType, code, codeType));
    }

    public static List<CompletionChoice> getStory(String topic) {
        OpenAi openAi = PARMS.get("OpenAi37");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), topic));
    }

    public static List<CompletionChoice> getStoryCreator(String text) {
        OpenAi openAi = PARMS.get("OpenAi38");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getNotesToSummary(String scene, String note) {
        OpenAi openAi = PARMS.get("OpenAi39");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), note));
    }

    public static List<CompletionChoice> getIdeaGenerator(String topic) {
        OpenAi openAi = PARMS.get("OpenAi40");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), topic));
    }

    public static List<CompletionChoice> getESRBRating(String text) {
        OpenAi openAi = PARMS.get("OpenAi41");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getEssayOutline(String text) {
        OpenAi openAi = PARMS.get("OpenAi42");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getRecipeCreator(String name, List<String> ingredients) {
        OpenAi openAi = PARMS.get("OpenAi43");
        StringJoiner joiner = new StringJoiner("\n");
        for (String ingredient : ingredients) {
            joiner.add(ingredient);
        }
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), name, joiner.toString()));
    }

    public static List<CompletionChoice> getAiChatbot(String question) {
        OpenAi openAi = PARMS.get("OpenAi44");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), question));
    }

    public static List<CompletionChoice> getMarvChatbot(String question) {
        OpenAi openAi = PARMS.get("OpenAi45");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), question));
    }

    public static List<CompletionChoice> getTurnDirection(String text) {
        OpenAi openAi = PARMS.get("OpenAi46");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getReviewCreator(String text) {
        OpenAi openAi = PARMS.get("OpenAi47");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getStudyNote(String text) {
        OpenAi openAi = PARMS.get("OpenAi48");
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    public static List<CompletionChoice> getInterviewQuestion(String text) {
        OpenAi openAi = PARMS.get("OpenAi49");
        System.out.println(String.format(openAi.getPrompt(), text));
        return OpenAiUtils.getAiResult(openAi, String.format(openAi.getPrompt(), text));
    }

    static {
        PARMS.put("OpenAi01", new OpenAi("OpenAi01", "\u95ee&\u7b54", "\u4f9d\u636e\u73b0\u6709\u77e5\u8bc6\u5e93\u95ee&\u7b54", "text-davinci-003", "Q: %s\nA:", 0.0, 1.0, 1.0, 0.0, 0.0, "\n"));
        PARMS.put("OpenAi02", new OpenAi("OpenAi02", "\u8bed\u6cd5\u7ea0\u6b63", "\u5c06\u53e5\u5b50\u8f6c\u6362\u6210\u6807\u51c6\u7684\u82f1\u8bed\uff0c\u8f93\u51fa\u7ed3\u679c\u59cb\u7ec8\u662f\u82f1\u6587", "text-davinci-003", "%s", 0.0, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi03", new OpenAi("OpenAi03", "\u5185\u5bb9\u6982\u51b5", "\u5c06\u4e00\u6bb5\u8bdd\uff0c\u6982\u51b5\u4e2d\u5fc3", "text-davinci-003", "Summarize this for a second-grade student:\n%s", 0.7, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi04", new OpenAi("OpenAi04", "\u751f\u6210OpenAi\u7684\u4ee3\u7801", "\u4e00\u53e5\u8bdd\u751f\u6210OpenAi\u7684\u4ee3\u7801", "code-davinci-002", "\"\"\"\nUtil exposes the following:\nutil.openai() -> authenticates & returns the openai module, which has the following functions:\nopenai.Completion.create(\n    prompt=\"<my prompt>\", # The prompt to start completing from\n    max_tokens=123, # The max number of tokens to generate\n    temperature=1.0 # A measure of randomness\n    echo=True, # Whether to return the prompt in addition to the generated completion\n)\n\"\"\"\nimport util\n\"\"\"\n%s\n\"\"\"\n\n", 0.0, 1.0, 1.0, 0.0, 0.0, "\"\"\""));
        PARMS.put("OpenAi05", new OpenAi("OpenAi05", "\u7a0b\u5e8f\u547d\u4ee4\u751f\u6210", "\u4e00\u53e5\u8bdd\u751f\u6210\u7a0b\u5e8f\u7684\u547d\u4ee4\uff0c\u76ee\u524d\u652f\u6301\u64cd\u4f5c\u7cfb\u7edf\u6307\u4ee4\u6bd4\u8f83\u591a", "text-davinci-003", "Convert this text to a programmatic command:\n\nExample: Ask Constance if we need some bread\nOutput: send-msg `find constance` Do we need some bread?\n\n%s", 0.0, 1.0, 1.0, 0.2, 0.0, ""));
        PARMS.put("OpenAi06", new OpenAi("OpenAi06", "\u8bed\u8a00\u7ffb\u8bd1", "\u628a\u4e00\u79cd\u8bed\u6cd5\u7ffb\u8bd1\u6210\u5176\u5b83\u51e0\u79cd\u8bed\u8a00", "text-davinci-003", "Translate this into %s:\n%s", 0.3, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi07", new OpenAi("OpenAi07", "Stripe\u56fd\u9645API\u751f\u6210", "\u4e00\u53e5\u8bdd\u751f\u6210Stripe\u56fd\u9645\u652f\u4ed8API", "code-davinci-002", "\"\"\"\nUtil exposes the following:\n\nutil.stripe() -> authenticates & returns the stripe module; usable as stripe.Charge.create etc\n\"\"\"\nimport util\n\"\"\"\n%s\n\"\"\"", 0.0, 1.0, 1.0, 0.0, 0.0, "\"\"\""));
        PARMS.put("OpenAi08", new OpenAi("OpenAi08", "SQL\u8bed\u53e5\u751f\u6210", "\u4f9d\u636e\u4e0a\u4e0b\u6587\u4e2d\u7684\u8868\u4fe1\u606f\uff0c\u751f\u6210SQL\u8bed\u53e5", "code-davinci-002", "### %s SQL tables, \u8868\u5b57\u6bb5\u4fe1\u606f\u5982\u4e0b:\n%s\n#\n### %s\n %s", 0.0, 1.0, 1.0, 0.0, 0.0, "# ;"));
        PARMS.put("OpenAi09", new OpenAi("OpenAi09", "\u7ed3\u6784\u5316\u751f\u6210", "\u5bf9\u4e8e\u975e\u7ed3\u6784\u5316\u7684\u6570\u636e\u62bd\u53d6\u5176\u4e2d\u7684\u7279\u5f81\u751f\u6210\u7ed3\u6784\u5316\u7684\u8868\u683c", "text-davinci-003", "A table summarizing, use Chinese:\n%s\n", 0.0, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi10", new OpenAi("OpenAi10", "\u4fe1\u606f\u5206\u7c7b", "\u628a\u4e00\u6bb5\u4fe1\u606f\u7ee7\u7eed\u5206\u7c7b", "text-davinci-003", "%s\n\u5206\u7c7b:", 0.0, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi11", new OpenAi("OpenAi11", "Python\u4ee3\u7801\u89e3\u91ca", "\u628a\u4ee3\u7801\u7ffb\u8bd1\u6210\u6587\u5b57\uff0c\u7528\u6765\u89e3\u91ca\u7a0b\u5e8f\u7684\u4f5c\u7528", "code-davinci-002", "# %s \n %s \n\n# \u89e3\u91ca\u4ee3\u7801\u4f5c\u7528\n\n#", 0.0, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi12", new OpenAi("OpenAi12", "\u6587\u5b57\u8f6c\u8868\u60c5\u7b26\u53f7", "\u5c06\u6587\u672c\u7f16\u7801\u6210\u8868\u60c5\u670d\u52a1", "text-davinci-003", "\u8f6c\u6362\u6587\u5b57\u4e3a\u8868\u60c5\u3002\n%s\uff1a", 0.8, 1.0, 1.0, 0.0, 0.0, "\n"));
        PARMS.put("OpenAi13", new OpenAi("OpenAi13", "\u65f6\u95f4\u590d\u6742\u5ea6\u8ba1\u7b97", "\u6c42\u4e00\u6bb5\u4ee3\u7801\u7684\u65f6\u95f4\u590d\u6742\u5ea6", "text-davinci-003", "%s\n\"\"\"\n\u51fd\u6570\u7684\u65f6\u95f4\u590d\u6742\u5ea6\u662f", 0.0, 1.0, 1.0, 0.0, 0.0, "\n"));
        PARMS.put("OpenAi14", new OpenAi("OpenAi14", "\u7a0b\u5e8f\u4ee3\u7801\u7ffb\u8bd1", "\u628a\u4e00\u79cd\u8bed\u8a00\u7684\u4ee3\u7801\u7ffb\u8bd1\u6210\u53e6\u5916\u4e00\u79cd\u8bed\u8a00\u7684\u4ee3\u7801", "code-davinci-002", "##### \u628a\u8fd9\u6bb5\u4ee3\u7801\u4ece%s\u7ffb\u8bd1\u6210%s\n### %s\n    \n   %s\n    \n### %s", 0.0, 1.0, 1.0, 0.0, 0.0, "###"));
        PARMS.put("OpenAi15", new OpenAi("OpenAi15", "\u9ad8\u7ea7\u60c5\u7eea\u8bc4\u5206", "\u652f\u6301\u6279\u91cf\u5217\u8868\u7684\u65b9\u5f0f\u68c0\u67e5\u60c5\u7eea", "text-davinci-003", "\u5bf9\u4e0b\u9762\u5185\u5bb9\u8fdb\u884c\u60c5\u611f\u5206\u7c7b:\n%s\"\n\u60c5\u7eea\u8bc4\u7ea7:", 0.0, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi16", new OpenAi("OpenAi16", "\u4ee3\u7801\u89e3\u91ca", "\u5bf9\u4e00\u6bb5\u4ee3\u7801\u8fdb\u884c\u89e3\u91ca", "code-davinci-002", "\u4ee3\u7801:\n%s\n\"\"\"\n\u4e0a\u9762\u7684\u4ee3\u7801\u5728\u505a\u4ec0\u4e48:\n1. ", 0.0, 1.0, 1.0, 0.0, 0.0, "\"\"\""));
        PARMS.put("OpenAi17", new OpenAi("OpenAi17", "\u5173\u952e\u5b57\u63d0\u53d6", "\u63d0\u53d6\u4e00\u6bb5\u6587\u672c\u4e2d\u7684\u5173\u952e\u5b57", "text-davinci-003", "\u62bd\u53d6\u4e0b\u9762\u5185\u5bb9\u7684\u5173\u952e\u5b57:\n%s", 0.5, 1.0, 1.0, 0.8, 0.0, ""));
        PARMS.put("OpenAi18", new OpenAi("OpenAi18", "\u95ee\u9898\u89e3\u7b54", "\u7c7b\u4f3c\u89e3\u7b54\u9898", "text-davinci-003", "Q: %s\nA: ?", 0.0, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi19", new OpenAi("OpenAi19", "\u5e7f\u544a\u8bbe\u8ba1", "\u7ed9\u4e00\u4e2a\u4ea7\u54c1\u8bbe\u8ba1\u4e00\u4e2a\u5e7f\u544a", "text-davinci-003", "\u4e3a\u4e0b\u9762\u7684\u4ea7\u54c1\u521b\u4f5c\u4e00\u4e2a\u521b\u4e1a\u5e7f\u544a\uff0c\u7528\u4e8e\u6295\u653e\u5230\u6296\u97f3\u4e0a\uff1a\n\u4ea7\u54c1:%s.", 0.5, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi20", new OpenAi("OpenAi20", "\u4ea7\u54c1\u53d6\u540d", "\u4f9d\u636e\u4ea7\u54c1\u63cf\u8ff0\u548c\u79cd\u5b50\u8bcd\u8bed\uff0c\u7ed9\u4e00\u4e2a\u4ea7\u54c1\u53d6\u4e00\u4e2a\u597d\u542c\u7684\u540d\u5b57", "text-davinci-003", "\u4ea7\u54c1\u63cf\u8ff0: %s.\n\u79cd\u5b50\u8bcd: %s.\n\u4ea7\u54c1\u540d\u79f0: ", 0.8, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi21", new OpenAi("OpenAi21", "\u53e5\u5b50\u7b80\u5316", "\u628a\u4e00\u4e2a\u957f\u53e5\u5b50\u7b80\u5316\u6210\u4e00\u4e2a\u77ed\u53e5\u5b50", "text-davinci-003", "%s\nTl;dr: ", 0.7, 1.0, 1.0, 0.0, 1.0, ""));
        PARMS.put("OpenAi22", new OpenAi("OpenAi22", "\u4fee\u590d\u4ee3\u7801Bug", "\u81ea\u52a8\u4fee\u6539\u4ee3\u7801\u4e2d\u7684bug", "code-davinci-002", "##### \u4fee\u590d\u4e0b\u9762\u4ee3\u7801\u7684bug\n### %s\n %s\n###  %s\n", 0.0, 1.0, 1.0, 0.0, 0.0, "###"));
        PARMS.put("OpenAi23", new OpenAi("OpenAi23", "\u8868\u683c\u586b\u5145\u6570\u636e", "\u81ea\u52a8\u4e3a\u4e00\u4e2a\u8868\u683c\u751f\u6210\u6570\u636e", "text-davinci-003", "spreadsheet ,%s rows:\n%s\n", 0.5, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi24", new OpenAi("OpenAi24", "\u8bed\u8a00\u804a\u5929\u673a\u5668\u4eba", "\u5404\u79cd\u5f00\u53d1\u8bed\u8a00\u7684\u4e24\u5929\u673a\u5668\u4eba", "code-davinci-002", "You: %s\n%s\u673a\u5668\u4eba:", 0.0, 1.0, 1.0, 0.5, 0.0, "You: "));
        PARMS.put("OpenAi25", new OpenAi("OpenAi25", "\u673a\u5668\u5b66\u4e60\u673a\u5668\u4eba", "\u673a\u5668\u5b66\u4e60\u6a21\u578b\u65b9\u9762\u7684\u673a\u5668\u4eba", "text-davinci-003", "You: %s\nML\u673a\u5668\u4eba:", 0.3, 1.0, 1.0, 0.5, 0.0, "You: "));
        PARMS.put("OpenAi26", new OpenAi("OpenAi26", "\u6e05\u5355\u5236\u4f5c", "\u53ef\u4ee5\u5217\u51fa\u5404\u65b9\u9762\u7684\u5206\u7c7b\u5217\u8868\uff0c\u6bd4\u5982\u6b4c\u5355", "text-davinci-003", "\u5217\u51fa10%s:", 0.5, 1.0, 1.0, 0.52, 0.5, "11.0"));
        PARMS.put("OpenAi27", new OpenAi("OpenAi27", "\u6587\u672c\u60c5\u7eea\u5206\u6790", "\u5bf9\u4e00\u6bb5\u6587\u5b57\u8fdb\u884c\u60c5\u7eea\u5206\u6790", "text-davinci-003", "\u63a8\u65ad\u4e0b\u9762\u6587\u672c\u7684\u60c5\u7eea\u662f\u79ef\u6781\u7684, \u4e2d\u7acb\u7684, \u8fd8\u662f\u6d88\u6781\u7684.\n\u6587\u672c: \"%s\"\n\u89c2\u70b9:", 0.0, 1.0, 1.0, 0.5, 0.0, ""));
        PARMS.put("OpenAi28", new OpenAi("OpenAi28", "\u822a\u7a7a\u4ee3\u7801\u62bd\u53d6", "\u62bd\u53d6\u6587\u672c\u4e2d\u7684\u822a\u7a7adiam\u4fe1\u606f", "text-davinci-003", "\u62bd\u53d6\u4e0b\u9762\u6587\u672c\u4e2d\u7684\u822a\u7a7a\u4ee3\u7801\uff1a\n\u6587\u672c\uff1a\"%s\"\n\u822a\u7a7a\u4ee3\u7801\uff1a", 0.0, 1.0, 1.0, 0.0, 0.0, "\n"));
        PARMS.put("OpenAi29", new OpenAi("OpenAi29", "\u751f\u6210SQL\u8bed\u53e5", "\u65e0\u4e0a\u4e0b\u6587\uff0c\u8bed\u53e5\u63cf\u8ff0\u751f\u6210SQL", "text-davinci-003", "%s", 0.3, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi30", new OpenAi("OpenAi30", "\u62bd\u53d6\u8054\u7cfb\u4fe1\u606f", "\u4ece\u6587\u672c\u4e2d\u62bd\u53d6\u8054\u7cfb\u65b9\u5f0f", "text-davinci-003", "\u4ece\u4e0b\u9762\u6587\u672c\u4e2d\u62bd\u53d6%s:\n%s", 0.0, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi31", new OpenAi("OpenAi31", "\u7a0b\u5e8f\u8bed\u8a00\u8f6c\u6362", "\u628a\u4e00\u79cd\u8bed\u8a00\u8f6c\u6210\u53e6\u5916\u4e00\u79cd\u8bed\u8a00", "code-davinci-002", "#%s to %s:\n%s:%s\n\n%s:", 0.0, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi32", new OpenAi("OpenAi32", "\u597d\u53cb\u804a\u5929", "\u6a21\u4eff\u597d\u53cb\u804a\u5929", "text-davinci-003", "You: %s\n\u597d\u53cb:", 0.5, 1.0, 1.0, 0.5, 0.0, "You:"));
        PARMS.put("OpenAi33", new OpenAi("OpenAi33", "\u989c\u8272\u751f\u6210", "\u4f9d\u636e\u63cf\u8ff0\u751f\u6210\u5bf9\u5e94\u989c\u8272", "text-davinci-003", "%s:\nbackground-color: ", 0.0, 1.0, 1.0, 0.0, 0.0, ";"));
        PARMS.put("OpenAi34", new OpenAi("OpenAi34", "\u7a0b\u5e8f\u6587\u6863\u751f\u6210", "\u81ea\u52a8\u4e3a\u7a0b\u5e8f\u751f\u6210\u6587\u6863", "code-davinci-002", "# %s\n \n%s\n# \u4e0a\u8ff0\u4ee3\u7801\u7684\u8be6\u7ec6\u3001\u9ad8\u8d28\u91cf\u6587\u6863\u5b57\u7b26\u4e32\uff1a\n\"\"\"", 0.0, 1.0, 1.0, 0.0, 0.0, "#\"\"\""));
        PARMS.put("OpenAi35", new OpenAi("OpenAi35", "\u6bb5\u843d\u521b\u4f5c", "\u4f9d\u636e\u77ed\u8bed\u751f\u6210\u76f8\u5173\u6587\u77ed", "text-davinci-003", "\u4e3a\u4e0b\u9762\u77ed\u8bed\u521b\u5efa\u4e00\u4e2a\u4e2d\u6587\u6bb5:\n%s:\n", 0.5, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi36", new OpenAi("OpenAi36", "\u4ee3\u7801\u538b\u7f29", "\u628a\u591a\u884c\u4ee3\u7801\u7b80\u5355\u7684\u538b\u7f29\u6210\u4e00\u884c", "code-davinci-002", "\u5c06\u4e0b\u9762%s\u4ee3\u7801\u8f6c\u6210\u4e00\u884c:\n%s\n%s\u4e00\u884c\u7248\u672c:", 0.0, 1.0, 1.0, 0.0, 0.0, ";"));
        PARMS.put("OpenAi37", new OpenAi("OpenAi37", "\u6545\u4e8b\u521b\u4f5c", "\u4f9d\u636e\u4e00\u4e2a\u4e3b\u9898\u521b\u5efa\u4e00\u4e2a\u6545\u4e8b", "text-davinci-003", "\u4e3b\u9898: %s\n\u6545\u4e8b\u521b\u4f5c:", 0.8, 1.0, 1.0, 0.5, 0.0, ""));
        PARMS.put("OpenAi38", new OpenAi("OpenAi38", "\u4eba\u79f0\u8f6c\u6362", "\u7b2c\u4e00\u4eba\u79f0\u8f6c\u7b2c3\u4eba\u79f0", "text-davinci-003", "\u628a\u4e0b\u9762\u5185\u5bb9\u4ece\u7b2c\u4e00\u4eba\u79f0\u8f6c\u4e3a\u7b2c\u4e09\u4eba\u79f0 (\u6027\u522b\u5973):\n%s\n", 0.0, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi39", new OpenAi("OpenAi39", "\u6458\u8981\u8bf4\u660e", "\u4f9d\u636e\u7b14\u8bb0\u751f\u6210\u6458\u8981\u8bf4\u660e", "text-davinci-003", "\u5c06\u4e0b\u9762\u5185\u5bb9\u8f6c\u6362\u6210\u5c06\u4e0b%s\u6458\u8981\uff1a\n%s", 0.0, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi40", new OpenAi("OpenAi40", "\u5934\u8111\u98ce\u66b4", "\u7ed9\u5b9a\u4e00\u4e2a\u4e3b\u9898\uff0c\u8ba9\u5176\u751f\u6210\u4e00\u4e9b\u4e3b\u9898\u76f8\u5173\u7684\u60f3\u6cd5", "text-davinci-003", "\u5934\u8111\u98ce\u66b4\u4e00\u4e9b\u5173\u4e8e%s\u7684\u60f3\u6cd5\uff1a", 0.6, 1.0, 1.0, 1.0, 1.0, ""));
        PARMS.put("OpenAi41", new OpenAi("OpenAi41", "ESRB\u6587\u672c\u5206\u7c7b", "\u6309\u7167ESRB\u8fdb\u884c\u6587\u672c\u5206\u7c7b", "text-davinci-003", "Provide an ESRB rating for the following text:\\n\\n\\\"%s\"\\n\\nESRB rating:", 0.3, 1.0, 1.0, 0.0, 0.0, "\n"));
        PARMS.put("OpenAi42", new OpenAi("OpenAi42", "\u63d0\u7eb2\u751f\u6210", "\u6309\u7167\u63d0\u793a\u4e3a\u76f8\u5173\u5185\u5bb9\u751f\u6210\u63d0\u7eb2", "text-davinci-003", "\u4e3a%s\u63d0\u7eb2:", 0.3, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi43", new OpenAi("OpenAi43", "\u7f8e\u98df\u5236\u4f5c\uff08\u540e\u679c\u81ea\u8d1f\uff09", "\u4f9d\u636e\u7f8e\u98df\u540d\u79f0\u548c\u6750\u6599\u751f\u6210\u7f8e\u98df\u7684\u5236\u4f5c\u6b65\u9aa4", "text-davinci-003", "\u4f9d\u636e\u4e0b\u9762\u6210\u5206\u548c\u7f8e\u98df\uff0c\u751f\u6210\u5236\u4f5c\u65b9\u6cd5:\n%s\n\u6210\u5206:\n%s\n\u5236\u4f5c\u65b9\u6cd5:", 0.3, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi44", new OpenAi("OpenAi44", "AI\u804a\u5929", "\u4e0eAI\u673a\u5668\u8fdb\u884c\u804a\u5929", "text-davinci-003", "Human: %s", 0.9, 1.0, 1.0, 0.0, 0.6, "Human:AI:"));
        PARMS.put("OpenAi45", new OpenAi("OpenAi45", "\u6446\u70c2\u804a\u5929", "\u4e0e\u8bbd\u523a\u673a\u5668\u8fdb\u884c\u804a\u5929", "text-davinci-003", "Marv\u4e0d\u60c5\u613f\u7684\u56de\u7b54\u95ee\u9898.\nYou:%s\nMarv:", 0.5, 0.3, 1.0, 0.5, 0.0, ""));
        PARMS.put("OpenAi46", new OpenAi("OpenAi46", "\u5206\u89e3\u6b65\u9aa4", "\u628a\u4e00\u6bb5\u6587\u672c\u5206\u89e3\u6210\u51e0\u6b65\u6765\u5b8c\u6210", "text-davinci-003", "\u4e3a\u4e0b\u9762\u6587\u672c\u751f\u6210\u6b21\u5e8f\u5217\u8868\uff0c\u5e76\u589e\u52a0\u5217\u8868\u6570\u5b50: \n%s\n", 0.3, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi47", new OpenAi("OpenAi47", "\u70b9\u8bc4\u751f\u6210", "\u4f9d\u636e\u6587\u672c\u5185\u5bb9\u81ea\u52a8\u751f\u6210\u70b9\u8bc4", "text-davinci-003", "\u4f9d\u636e\u4e0b\u9762\u5185\u5bb9\uff0c\u8fdb\u884c\u70b9\u8bc4:\n%s\n\u70b9\u8bc4:", 0.5, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi48", new OpenAi("OpenAi48", "\u77e5\u8bc6\u5b66\u4e60", "\u53ef\u4ee5\u4e3a\u5b66\u4e60\u77e5\u8bc6\u81ea\u52a8\u89e3\u7b54", "text-davinci-003", "%s", 0.3, 1.0, 1.0, 0.0, 0.0, ""));
        PARMS.put("OpenAi49", new OpenAi("OpenAi49", "\u9762\u8bd5", "\u751f\u6210\u9762\u8bd5\u9898", "text-davinci-003", "\u521b\u5efa10\u9053%s\u76f8\u5173\u7684\u9762\u8bd5\u9898\uff08\u4e2d\u6587\uff09\uff1a\n", 0.5, 1.0, 10.0, 0.0, 0.0, ""));
        OPENAPI_TOKEN = "";
        TIMEOUT = null;
    }
}

