/*
 * Decompiled with CFR 0.152.
 */
package com.gj.utils;

import com.gj.utils.excel.ExportExcel;
import java.lang.reflect.Array;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public final class GjUtil {
    public static boolean paramIsEmpty(Object str) {
        if (str instanceof List) {
            return ((List)str).isEmpty();
        }
        if (str instanceof Map) {
            return ((Map)str).isEmpty();
        }
        if (str instanceof Array) {
            return Array.getLength(str) == 0;
        }
        return str == null || "".equals(str);
    }

    public static <T> boolean multiParamHasEmpty(List<T> params) {
        List paramNullList = params.stream().filter(GjUtil::paramIsEmpty).collect(Collectors.toList());
        return !paramNullList.isEmpty();
    }

    public static boolean paramIsNotEmpty(Object str) {
        return !GjUtil.paramIsEmpty(str);
    }

    public static String trim(String str) {
        return GjUtil.paramIsEmpty(str) ? null : str.trim();
    }

    public static List<String> trim(List<String> list) {
        List listNonNull = list.stream().filter(GjUtil::paramIsNotEmpty).collect(Collectors.toList());
        return listNonNull.size() <= 0 ? null : listNonNull.stream().map(GjUtil::trim).collect(Collectors.toList());
    }

    public static String toUpperCase(@NonNull String str) {
        return GjUtil.paramIsEmpty(str) ? null : str.toUpperCase();
    }

    public static String toLowerCase(@NonNull String str) {
        return GjUtil.paramIsEmpty(str) ? null : str.toLowerCase();
    }

    public static String removeSymbol(String str, @Nullable String symbol) {
        if (GjUtil.paramIsEmpty(str)) {
            return null;
        }
        str = GjUtil.removeStartSymbol(str, symbol);
        return GjUtil.removeEndSymbol(str, symbol);
    }

    public static String removeStartSymbol(String str, String symbol) {
        int strLen = 0;
        if (GjUtil.paramIsNotEmpty(str) && (strLen = str.length()) != 0) {
            int start;
            if (GjUtil.paramIsEmpty(symbol)) {
                return GjUtil.trim(str);
            }
            for (start = 0; start != strLen && symbol.indexOf(str.charAt(start)) != -1; ++start) {
            }
            return str.substring(start);
        }
        return GjUtil.trim(str);
    }

    public static String removeEndSymbol(String str, String symbol) {
        int end;
        if (GjUtil.paramIsNotEmpty(str) && (end = str.length()) != 0) {
            if (GjUtil.paramIsEmpty(symbol)) {
                return GjUtil.trim(str);
            }
            while (end != 0 && symbol.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
            return str.substring(0, end);
        }
        return GjUtil.trim(str);
    }

    public static String[] spilt(String str, String symbol) {
        if (GjUtil.paramIsEmpty(str) || symbol.length() != 1) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        while (i < str.length()) {
            if (String.valueOf(str.charAt(i)).equals(symbol)) {
                list.add(str.substring(start, i));
                start = ++i;
                continue;
            }
            ++i;
        }
        return list.toArray(new String[0]);
    }

    public static String md5(@NonNull String body) {
        StringBuilder buf = new StringBuilder();
        try {
            byte[] b;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(body.getBytes());
            for (int n : b = md.digest()) {
                int i = n;
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        return buf.toString();
    }

    public static void excelExport(HttpServletResponse response, List<Object[]> list, String[] headers, String title, @Nullable String info) {
        ExportExcel.generateHaveExcelName(response, list, headers, title, info);
    }

    public static boolean contains(String[] t, String u) {
        if (t.length < 1) {
            return false;
        }
        if (GjUtil.paramIsEmpty(u)) {
            return false;
        }
        for (String t1 : t) {
            if (!t1.equals(u)) continue;
            return true;
        }
        return false;
    }

    public static String getDateAsString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static String getDateAsString(Date date, String format) {
        SimpleDateFormat format1 = new SimpleDateFormat(format);
        return format1.format(format);
    }

    public static Date getDate(String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.parse(date);
    }

    public static Date getDate(String date, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.parse(date);
    }

    public static Calendar dateToCalendar(String str) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(simpleDateFormat.parse(str));
        return calendar;
    }
}

