/*
 * Decompiled with CFR 0.152.
 */
package com.gjing.utils.http;

import com.gjing.config.HttpsClientRequestFactory;
import com.gjing.enums.HttpStatus;
import com.gjing.enums.HttpType;
import com.gjing.ex.HttpException;
import com.gjing.utils.ParamUtil;
import com.gjing.utils.http.UrlUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpRequest.class);
    private static RestTemplate restTemplate;

    public String post(String requestUrl) {
        if (requestUrl == null) {
            throw new NullPointerException("Parameter requestUrl cannot be null");
        }
        try {
            this.checkRequestType(requestUrl);
            return (String)restTemplate.postForEntity(requestUrl, (Object)HttpMethod.POST, String.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage());
        }
    }

    public String post(String requestUrl, Map<String, String> params) {
        if (requestUrl == null) {
            throw new NullPointerException("Parameter requestUrl cannot be null");
        }
        if (params == null) {
            throw new NullPointerException("Parameter params cannot be null");
        }
        try {
            this.checkRequestType(requestUrl);
            return (String)restTemplate.postForEntity(requestUrl, this.mapToMultiValueMap(params), String.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage());
        }
    }

    public String post(String requestUrl, Map<String, String> params, Map<String, String> headers) {
        if (requestUrl == null) {
            throw new NullPointerException("Parameter requestUrl cannot be null");
        }
        if (headers == null) {
            throw new NullPointerException("Parameter headers cannot be null");
        }
        try {
            this.checkRequestType(requestUrl);
            HttpHeaders httpHeaders = new HttpHeaders();
            for (String s : headers.keySet()) {
                httpHeaders.add(s, headers.get(s));
            }
            HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
            if (ParamUtil.paramIsNotEmpty(params)) {
                httpEntity = new HttpEntity(this.mapToMultiValueMap(params), (MultiValueMap)httpHeaders);
            }
            return (String)restTemplate.exchange(requestUrl, HttpMethod.POST, httpEntity, String.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage());
        }
    }

    public String post(String requestUrl, Map<String, String> params, Map<String, String> headers, String proxyIp, String proxyPort) {
        if (requestUrl == null) {
            throw new NullPointerException("Parameter requestUrl cannot be null");
        }
        if (params == null) {
            throw new NullPointerException("Parameter params cannot be null");
        }
        if (headers == null) {
            throw new NullPointerException("Parameter headers cannot be null");
        }
        if (proxyIp == null) {
            throw new NullPointerException("Parameter proxyIp cannot be null");
        }
        if (proxyPort == null) {
            throw new NullPointerException("Parameter proxyPort cannot be null");
        }
        if (!ParamUtil.multiParamHasEmpty(Arrays.asList(proxyIp, proxyPort))) {
            this.setProxy(proxyIp, proxyPort);
        }
        try {
            this.checkRequestType(requestUrl);
            if (ParamUtil.paramIsNotEmpty(headers)) {
                HttpHeaders httpHeaders = new HttpHeaders();
                for (String s : headers.keySet()) {
                    httpHeaders.add(s, headers.get(s));
                }
                HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
                if (ParamUtil.paramIsNotEmpty(params)) {
                    httpEntity = new HttpEntity(this.mapToMultiValueMap(params), (MultiValueMap)httpHeaders);
                }
                return (String)restTemplate.exchange(requestUrl, HttpMethod.POST, httpEntity, String.class, new Object[0]).getBody();
            }
            if (ParamUtil.paramIsNotEmpty(params)) {
                return (String)restTemplate.postForEntity(requestUrl, this.mapToMultiValueMap(params), String.class, new Object[0]).getBody();
            }
            return (String)restTemplate.postForEntity(requestUrl, (Object)HttpMethod.POST, String.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HttpException(e.getCause().getMessage());
        }
    }

    public String get(String requestUrl) {
        if (requestUrl == null) {
            throw new NullPointerException("Parameter requestUrl cannot be null");
        }
        try {
            this.checkRequestType(requestUrl);
            return (String)restTemplate.getForObject(requestUrl, String.class, new Object[0]);
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage());
        }
    }

    public String get(String requestUrl, Map<String, String> params) {
        if (requestUrl == null) {
            throw new NullPointerException("Parameter requestUrl cannot be null");
        }
        if (params == null) {
            throw new NullPointerException("Parameter params cannot be null");
        }
        try {
            this.checkRequestType(requestUrl);
            return (String)restTemplate.getForObject(UrlUtil.urlAppend(requestUrl, params), String.class, params);
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage());
        }
    }

    public String get(String requestUrl, Map<String, String> params, Map<String, String> headers) {
        if (requestUrl == null) {
            throw new NullPointerException("Parameter requestUrl cannot be null");
        }
        if (headers == null) {
            throw new NullPointerException("Parameter headers cannot be null");
        }
        try {
            this.checkRequestType(requestUrl);
            HttpHeaders httpHeaders = new HttpHeaders();
            for (String s : headers.keySet()) {
                httpHeaders.add(s, headers.get(s));
            }
            HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
            if (ParamUtil.paramIsNotEmpty(params)) {
                return (String)restTemplate.exchange(UrlUtil.urlAppend(requestUrl, params), HttpMethod.GET, httpEntity, String.class, params).getBody();
            }
            return (String)restTemplate.exchange(requestUrl, HttpMethod.GET, httpEntity, String.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            throw new HttpException(e.getMessage());
        }
    }

    public String get(String requestUrl, Map<String, String> params, Map<String, String> headers, String proxyIp, String proxyPort) {
        if (requestUrl == null) {
            throw new NullPointerException("Parameter requestUrl cannot be null");
        }
        if (proxyIp == null) {
            throw new NullPointerException("Parameter proxyIp cannot be null");
        }
        if (proxyPort == null) {
            throw new NullPointerException("Parameter proxyPort cannot be null");
        }
        if (!ParamUtil.multiParamHasEmpty(Arrays.asList(proxyIp, proxyPort))) {
            this.setProxy(proxyIp, proxyPort);
        }
        try {
            this.checkRequestType(requestUrl);
            if (ParamUtil.paramIsNotEmpty(headers)) {
                HttpHeaders httpHeaders = new HttpHeaders();
                for (String s : headers.keySet()) {
                    httpHeaders.add(s, headers.get(s));
                }
                HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
                if (ParamUtil.paramIsNotEmpty(params)) {
                    return (String)restTemplate.exchange(UrlUtil.urlAppend(requestUrl, params), HttpMethod.GET, httpEntity, String.class, params).getBody();
                }
                return (String)restTemplate.exchange(requestUrl, HttpMethod.GET, httpEntity, String.class, new Object[0]).getBody();
            }
            if (ParamUtil.paramIsNotEmpty(params)) {
                return (String)restTemplate.getForObject(UrlUtil.urlAppend(requestUrl, params), String.class, params);
            }
            return (String)restTemplate.getForObject(requestUrl, String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HttpException(HttpStatus.BAD_REQUEST.getMsg());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkRequestType(String url) {
        String[] urlArr = ParamUtil.split(url, ":");
        if (!ParamUtil.paramIsNotEmpty(urlArr)) throw new HttpException("The parameter requestUrl cannot be null");
        if (Objects.equals(ParamUtil.toLowerCase(urlArr[0]), HttpType.HTTP.getType())) {
            restTemplate = new RestTemplate();
            return;
        } else {
            if (!Objects.equals(ParamUtil.toLowerCase(urlArr[0]), HttpType.HTTPS.getType())) throw new HttpException("The requested url is invalid, please use an http or https address");
            restTemplate = new RestTemplate((ClientHttpRequestFactory)new HttpsClientRequestFactory());
        }
    }

    private MultiValueMap<String, String> mapToMultiValueMap(Map<String, String> map) {
        LinkedMultiValueMap multiValueMap = new LinkedMultiValueMap();
        for (String s : map.keySet()) {
            multiValueMap.add((Object)s, (Object)map.get(s));
        }
        return multiValueMap;
    }

    private void setProxy(String proxyHost, String proxyPort) {
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", proxyPort);
        System.setProperty("https.proxyHost", proxyHost);
        System.setProperty("https.proxyPort", proxyPort);
    }
}

