/*
 * Decompiled with CFR 0.152.
 */
package com.gjing.utils.ali.oss;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.gjing.enums.HttpStatus;
import com.gjing.ex.OssException;
import com.gjing.utils.ParamUtil;
import com.gjing.utils.TimeUtil;
import com.gjing.utils.ali.oss.OssModel;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.springframework.web.multipart.MultipartFile;

public class AliOss {
    private static OSSClient instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OSSClient getOssClient(OssModel ossModel) {
        if (instance != null) return instance;
        Class<AliOss> clazz = AliOss.class;
        synchronized (AliOss.class) {
            if (instance != null) return instance;
            instance = new OSSClient(ossModel.getEndPoint(), ossModel.getAccessKeyId(), ossModel.getAccessKeySecret());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private static void createBucket(OssModel ossModel) {
        try {
            if (!AliOss.getOssClient(ossModel).doesBucketExist(ossModel.getBucketName())) {
                AliOss.getOssClient(ossModel).createBucket(ossModel.getBucketName());
            }
        }
        catch (Exception e) {
            throw new OssException("\u521b\u5efaBucket\u5931\u8d25,\u8bf7\u6838\u5bf9Bucket\u540d\u79f0(\u89c4\u5219\uff1a\u53ea\u80fd\u5305\u542b\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u77ed\u6a2a\u7ebf\uff0c\u5fc5\u987b\u4ee5\u5c0f\u5199\u5b57\u6bcd\u548c\u6570\u5b57\u5f00\u5934\u548c\u7ed3\u5c3e\uff0c\u957f\u5ea6\u57283-63\u4e4b\u95f4)");
        }
    }

    private static String getContentType(String fileName) {
        String fileExtension = fileName.substring(fileName.lastIndexOf(".") + 1);
        if ("bmp".equalsIgnoreCase(fileExtension)) {
            return "image/bmp";
        }
        if ("gif".equalsIgnoreCase(fileExtension)) {
            return "image/gif";
        }
        if ("jpeg".equalsIgnoreCase(fileExtension) || "jpg".equalsIgnoreCase(fileExtension)) {
            return "image/jpeg";
        }
        if ("png".equalsIgnoreCase(fileExtension)) {
            return "image/png";
        }
        if ("html".equalsIgnoreCase(fileExtension)) {
            return "text/html";
        }
        if ("txt".equalsIgnoreCase(fileExtension)) {
            return "text/plain";
        }
        if ("vsd".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.visio";
        }
        if ("ppt".equalsIgnoreCase(fileExtension) || "pptx".equalsIgnoreCase(fileExtension)) {
            return "application/vnd.ms-powerpoint";
        }
        if ("doc".equalsIgnoreCase(fileExtension) || "docx".equalsIgnoreCase(fileExtension)) {
            return "application/msword";
        }
        if ("xml".equalsIgnoreCase(fileExtension)) {
            return "text/xml";
        }
        return "text/html";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String uploadFile(MultipartFile file, OssModel ossModel) {
        String fileName = String.format("%s.%s", UUID.randomUUID().toString(), FilenameUtils.getExtension((String)file.getOriginalFilename()));
        try (InputStream inputStream = file.getInputStream();){
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)inputStream.available());
            objectMetadata.setCacheControl("no-cache");
            objectMetadata.setHeader("Pragma", (Object)"no-cache");
            objectMetadata.setContentType(FilenameUtils.getExtension((String)("." + file.getOriginalFilename())));
            objectMetadata.setContentDisposition("inline;filename=" + fileName);
            if (ParamUtil.paramIsNotEmpty(ossModel.getFileDir())) {
                AliOss.getOssClient(ossModel).putObject(ossModel.getBucketName(), ossModel.getFileDir() + "/" + fileName, inputStream, objectMetadata);
                String string = ossModel.getFileDir() + "/" + fileName;
                return string;
            }
            AliOss.getOssClient(ossModel).putObject(ossModel.getBucketName(), fileName, inputStream, objectMetadata);
            String string = fileName;
            return string;
        }
        catch (Exception oe) {
            throw new OssException(oe.getMessage());
        }
    }

    private static String getFileUrl(String fileUrl, OssModel ossModel) {
        if (ParamUtil.paramIsEmpty(fileUrl)) {
            throw new OssException("The parameter fileUrl cannot be null!");
        }
        String[] split = ParamUtil.split(fileUrl, "/");
        if (ParamUtil.paramIsEmpty(split)) {
            throw new OssException(HttpStatus.INVALID_PARAMETER.getMsg());
        }
        URL url = ParamUtil.paramIsNotEmpty(ossModel.getFileDir()) ? AliOss.getOssClient(ossModel).generatePresignedUrl(ossModel.getBucketName(), ossModel.getFileDir() + "/" + split[split.length - 1], TimeUtil.addDay(new Date(), 3650)) : AliOss.getOssClient(ossModel).generatePresignedUrl(ossModel.getBucketName(), split[split.length - 1], TimeUtil.addDay(new Date(), 3650));
        if (url == null) {
            throw new OssException("get oss file url error");
        }
        return url.toString();
    }

    private static String getPathUrl(String fileName, OssModel ossModel) {
        return fileName.substring(fileName.indexOf(ossModel.getEndPoint()) + ossModel.getEndPoint().length() + 1);
    }

    public static boolean delete(List<String> urls, OssModel ossModel) {
        if (urls == null) {
            throw new NullPointerException("Parameter urls cannot be null");
        }
        if (ossModel == null) {
            throw new NullPointerException("Parameter ossModel cannot be null");
        }
        List urlList = urls.stream().map(e -> AliOss.getPathUrl(e, ossModel)).collect(Collectors.toList());
        try {
            AliOss.getOssClient(ossModel).deleteObjects(new DeleteObjectsRequest(ossModel.getBucketName()).withKeys(urlList));
            return true;
        }
        catch (RuntimeException e2) {
            throw new OssException(e2.getMessage());
        }
    }

    public static String upload(MultipartFile file, OssModel ossModel) {
        if (file == null) {
            throw new NullPointerException("Parameter file cannot be null");
        }
        if (ossModel == null) {
            throw new NullPointerException("Parameter ossModel cannot be null");
        }
        if (file.getSize() > 0x40000000L) {
            throw new OssException("Upload failed. file size cannot more than 5 gb");
        }
        AliOss.createBucket(ossModel);
        String fileName = AliOss.uploadFile(file, ossModel);
        String fileOssUrl = AliOss.getFileUrl(fileName, ossModel);
        int firstChar = fileOssUrl.indexOf("?");
        if (firstChar > 0) {
            fileOssUrl = fileOssUrl.substring(0, firstChar);
        }
        return fileOssUrl;
    }

    public static boolean downloadFile(OssModel ossModel, String fileName, String localFile) {
        if (ossModel == null) {
            throw new NullPointerException("Parameter ossModel cannot be null");
        }
        if (fileName == null) {
            throw new NullPointerException("Parameter fileName cannot be null");
        }
        if (localFile == null) {
            throw new NullPointerException("Parameter localFile cannot be null");
        }
        try {
            OSSClient ossClient = AliOss.getOssClient(ossModel);
            ossClient.getObject(new GetObjectRequest(ossModel.getBucketName(), fileName), new File(localFile));
            return true;
        }
        catch (RuntimeException e) {
            throw new OssException(e.getMessage());
        }
    }
}

