/*
 * Decompiled with CFR 0.152.
 */
package com.gjing.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class TimeUtil {
    public static String getDateAsString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static String getDateAsString(Date date, String format) {
        SimpleDateFormat format1 = new SimpleDateFormat(format);
        return format1.format(format);
    }

    public static Date getDate(String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.parse(date);
    }

    public static Date getDate(String date, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.parse(date);
    }

    public static Calendar dateToCalendar(String str) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(simpleDateFormat.parse(str));
        return calendar;
    }

    public static Date calendarToDate(Calendar calendar, String format) throws ParseException {
        return TimeUtil.getDate(TimeUtil.calendarToStringDate(calendar, format));
    }

    public static String calendarToStringDate(Calendar calendar, String format) {
        return TimeUtil.getDateAsString(calendar.getTime(), format);
    }

    public static int getAllDaysOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(5);
    }

    public static int getDays(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getYears(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }

    public static Long stringDateToStamp(String stringDate) throws ParseException {
        return TimeUtil.getDate(stringDate).getTime();
    }

    public static String stampToStringDate(Long timeStamp) {
        long l = timeStamp;
        return TimeUtil.getDateAsString(new Date(l));
    }

    public static int dateBetween(String startDate, String endDate) throws ParseException {
        Date dateStart = TimeUtil.getDate(startDate, "yyyy-MM-dd");
        Date dateEnd = TimeUtil.getDate(endDate, "yyyy-MM-dd");
        return (int)((dateEnd.getTime() - dateStart.getTime()) / 1000L / 60L / 60L / 24L);
    }

    public static int dateBetweenIncludeToday(String startDate, String endDate) throws ParseException {
        return TimeUtil.dateBetween(startDate, endDate) + 1;
    }
}

