/*
 * Decompiled with CFR 0.152.
 */
package com.gjing.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class ParamUtil {
    public static <T> boolean paramIsEmpty(T str) {
        if (str == null) {
            return true;
        }
        if (str instanceof Collection) {
            return ((List)str).isEmpty();
        }
        if (str instanceof Map) {
            return ((Map)str).isEmpty();
        }
        if (str.getClass().isArray()) {
            return Array.getLength(str) == 0;
        }
        return "".equals(str);
    }

    public static <T> boolean multiParamHasEmpty(List<T> params) {
        List paramNullList = params.stream().filter(ParamUtil::paramIsEmpty).collect(Collectors.toList());
        return !paramNullList.isEmpty();
    }

    public static boolean paramIsNotEmpty(Object str) {
        return !ParamUtil.paramIsEmpty(str);
    }

    public static String trim(String str) {
        return ParamUtil.paramIsEmpty(str) ? null : str.trim();
    }

    public static List<String> trim(List<String> list) {
        List listNonNull = list.stream().filter(ParamUtil::paramIsNotEmpty).collect(Collectors.toList());
        return listNonNull.size() <= 0 ? null : listNonNull.stream().map(ParamUtil::trim).collect(Collectors.toList());
    }

    public static String toUpperCase(String str) {
        return ParamUtil.paramIsEmpty(str) ? null : str.toUpperCase();
    }

    public static String toLowerCase(String str) {
        return ParamUtil.paramIsEmpty(str) ? null : str.toLowerCase();
    }

    public static String removeSymbol(String str, String symbol) {
        if (ParamUtil.paramIsEmpty(str)) {
            return null;
        }
        str = ParamUtil.removeStartSymbol(str, symbol);
        return ParamUtil.removeEndSymbol(str, symbol);
    }

    public static String removeStartSymbol(String str, String symbol) {
        int strLen;
        if (ParamUtil.paramIsNotEmpty(str) && (strLen = str.length()) != 0) {
            int start;
            if (ParamUtil.paramIsEmpty(symbol)) {
                return ParamUtil.trim(str);
            }
            for (start = 0; start != strLen && symbol.indexOf(str.charAt(start)) != -1; ++start) {
            }
            return str.substring(start);
        }
        return ParamUtil.trim(str);
    }

    public static String removeEndSymbol(String str, String symbol) {
        int end;
        if (ParamUtil.paramIsNotEmpty(str) && (end = str.length()) != 0) {
            if (ParamUtil.paramIsEmpty(symbol)) {
                return ParamUtil.trim(str);
            }
            while (end != 0 && symbol.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
            return str.substring(0, end);
        }
        return ParamUtil.trim(str);
    }

    public static String[] split(String str, String symbol) {
        if (ParamUtil.paramIsEmpty(str) || symbol.length() != 1) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        while (i < str.length()) {
            if (String.valueOf(str.charAt(i)).equals(symbol)) {
                list.add(str.substring(start, i));
                start = ++i;
                continue;
            }
            ++i;
        }
        list.add(str.substring(start));
        return list.toArray(new String[0]);
    }

    public static String removeSymbol2(String str, String symbol) {
        if (ParamUtil.paramIsEmpty(str) || symbol.length() > 1) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        String[] strings = ParamUtil.split(str, symbol);
        if (ParamUtil.paramIsNotEmpty(strings)) {
            for (String s : strings) {
                builder.append(s);
            }
            return builder.toString();
        }
        return null;
    }

    public static boolean contains(String[] t, String u) {
        if (t.length < 1) {
            return false;
        }
        if (ParamUtil.paramIsEmpty(u)) {
            return false;
        }
        for (String t1 : t) {
            if (!t1.equals(u)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmail(String email) {
        String regex = "^([a-z0-9_\\.-]+)@([\\da-z\\.-]+)\\.([a-z\\.]{2,6})$";
        if (ParamUtil.paramIsNotEmpty(email)) {
            return Pattern.compile(regex).matcher(email).matches();
        }
        return false;
    }

    public static boolean isMobileNumber(String phone) {
        String regex = "^1([3-8]){1}\\d{9}$";
        if (ParamUtil.paramIsNotEmpty(phone)) {
            return Pattern.compile(regex).matcher(phone).matches();
        }
        return false;
    }

    public static boolean isTelPhone(String tel) {
        String regex = "^(0[0-9]{2,3}\\-)?([2-9][0-9]{6,7})+(\\-[0-9]{1,4})?$";
        if (ParamUtil.paramIsNotEmpty(tel)) {
            return Pattern.compile(regex).matcher(tel).matches();
        }
        return false;
    }

    public static boolean isPostCode(String postCode) {
        String regex = "^\\d{6}$";
        if (ParamUtil.paramIsNotEmpty(postCode)) {
            return Pattern.compile(regex).matcher(postCode).matches();
        }
        return false;
    }
}

