/*
 * Decompiled with CFR 0.152.
 */
package com.gjing.utils.http;

import com.gjing.utils.ParamUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.MultiValueMap;

public class UrlUtil {
    public static String urlAppend(String url, MultiValueMap<String, String> map) {
        StringBuilder builder = new StringBuilder();
        builder.append(url).append("?");
        for (String s : map.keySet()) {
            if (map.size() == 1) {
                builder.append(s).append("=").append("{").append(s).append("}");
                continue;
            }
            builder.append(s).append("=").append("{").append(s).append("}&");
        }
        return builder.toString().substring(0, builder.toString().length() - 1);
    }

    public static String urlAppend(String url, Map<String, String> map) {
        StringBuilder builder = new StringBuilder();
        builder.append(url).append("?");
        for (String s : map.keySet()) {
            if (map.size() == 1) {
                builder.append(s).append("=").append("{").append(s).append("}");
                continue;
            }
            builder.append(s).append("=").append("{").append(s).append("}&");
        }
        if (map.size() == 1) {
            return builder.toString();
        }
        return builder.toString().substring(0, builder.toString().length() - 1);
    }

    public static String unicodeSort(Map<String, String> paraMap, boolean urlEncode, boolean keyToLower) {
        String buff;
        try {
            ArrayList<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(paraMap.entrySet());
            infoIds.sort(Comparator.comparing(Map.Entry::getKey));
            StringBuilder buf = new StringBuilder();
            for (Map.Entry entry : infoIds) {
                if (!ParamUtil.paramIsNotEmpty(entry.getKey())) continue;
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (urlEncode) {
                    val = URLEncoder.encode(val, "utf-8");
                }
                if (keyToLower) {
                    buf.append(key.toLowerCase()).append("=").append(val);
                } else {
                    buf.append(key).append("=").append(val);
                }
                buf.append("&");
            }
            buff = buf.toString();
            if (ParamUtil.paramIsNotEmpty(buf)) {
                buff = buff.substring(0, buff.length() - 1);
            }
        }
        catch (Exception e) {
            return null;
        }
        return buff;
    }

    public static Map<String, String> urlParamToMap(String queryString) {
        String[] pairs;
        ConcurrentHashMap<String, String> queryPairs = new ConcurrentHashMap<String, String>(16);
        for (String pair : pairs = queryString.split("&")) {
            int idx = pair.indexOf("=");
            try {
                String value;
                String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                String string = value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
                if (key.isEmpty()) continue;
                queryPairs.put(key, value);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return queryPairs;
    }
}

