/*
 * Decompiled with CFR 0.152.
 */
package com.gjing.utils.ali.sms;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.gjing.annotation.NotNull;
import com.gjing.enums.Sms;
import com.gjing.ex.SmsException;
import com.gjing.utils.ParamUtil;
import com.google.gson.Gson;
import java.util.Map;

public class AliSms {
    private static Gson gson = new Gson();

    @NotNull(exclude={"smsTemplateParam"})
    public static synchronized String send(String accessKeyId, String accessSecret, String phoneNumbers, String smsTemplateCode, Map<String, String> smsTemplateParam, String smsSignName) {
        DefaultProfile profile = DefaultProfile.getProfile((String)"default", (String)accessKeyId, (String)accessSecret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain(Sms.SMS.getApi());
        request.setAction(Sms.SMS.getAction());
        request.setVersion(Sms.SMS.getVersion());
        request.putQueryParameter("PhoneNumbers", phoneNumbers);
        request.putQueryParameter("TemplateCode", smsTemplateCode);
        if (ParamUtil.paramIsNotEmpty(smsTemplateParam)) {
            request.putQueryParameter("TemplateParam", gson.toJson(smsTemplateParam));
        }
        request.putQueryParameter("SignName", smsSignName);
        try {
            CommonResponse response = client.getCommonResponse(request);
            return response.getData();
        }
        catch (ClientException e) {
            throw new SmsException(e.getMessage());
        }
    }

    public static synchronized String querySendDetails(String accessKeyId, String accessSecret, String phoneNumber, String sendData, String pageSize, String currentPage) {
        if (accessKeyId == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
        if (accessSecret == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
        if (phoneNumber == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
        if (sendData == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
        if (pageSize == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
        if (currentPage == null) {
            throw new NullPointerException("Parameter cannot be null");
        }
        if (!ParamUtil.isMobileNumber(phoneNumber)) {
            throw new SmsException("Specified parameter phoneNumber is not valid");
        }
        DefaultProfile profile = DefaultProfile.getProfile((String)"default", (String)accessKeyId, (String)accessSecret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        CommonRequest request = new CommonRequest();
        request.setMethod(MethodType.POST);
        request.setDomain(Sms.QUERY.getApi());
        request.setVersion(Sms.QUERY.getVersion());
        request.setAction(Sms.QUERY.getAction());
        request.putQueryParameter("PhoneNumber", phoneNumber);
        request.putQueryParameter("SendDate", ParamUtil.removeSymbol2(sendData, "-"));
        request.putQueryParameter("PageSize", pageSize);
        request.putQueryParameter("CurrentPage", currentPage);
        try {
            CommonResponse response = client.getCommonResponse(request);
            return response.getData();
        }
        catch (ClientException e) {
            throw new SmsException(e.getMessage());
        }
    }
}

