/*
 * Decompiled with CFR 0.152.
 */
package com.gjing.utils.ali.oss;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.ObjectMetadata;
import com.gjing.enums.HttpStatus;
import com.gjing.ex.OssException;
import com.gjing.utils.ParamUtil;
import com.gjing.utils.TimeUtil;
import com.gjing.utils.ali.oss.OssModel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.springframework.web.multipart.MultipartFile;

public class AliOss {
    private static OSSClient instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static OSSClient getOssClient(OssModel ossModel) {
        if (instance != null) return instance;
        Class<AliOss> clazz = AliOss.class;
        synchronized (AliOss.class) {
            if (instance != null) return instance;
            instance = new OSSClient(ossModel.getEndPoint(), ossModel.getAccessKeyId(), ossModel.getAccessKeySecret());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    private static void createBucket(OssModel ossModel) {
        try {
            if (!AliOss.getOssClient(ossModel).doesBucketExist(ossModel.getBucketName())) {
                AliOss.getOssClient(ossModel).createBucket(ossModel.getBucketName());
            }
        }
        catch (Exception e) {
            throw new OssException("\u521b\u5efaBucket\u5931\u8d25,\u8bf7\u6838\u5bf9Bucket\u540d\u79f0(\u89c4\u5219\uff1a\u53ea\u80fd\u5305\u542b\u5c0f\u5199\u5b57\u6bcd\u3001\u6570\u5b57\u548c\u77ed\u6a2a\u7ebf\uff0c\u5fc5\u987b\u4ee5\u5c0f\u5199\u5b57\u6bcd\u548c\u6570\u5b57\u5f00\u5934\u548c\u7ed3\u5c3e\uff0c\u957f\u5ea6\u57283-63\u4e4b\u95f4)");
        }
    }

    private static String getContentType(String filenameExtension) {
        if (filenameExtension.equalsIgnoreCase("jpeg") || filenameExtension.equalsIgnoreCase("jpg") || filenameExtension.equalsIgnoreCase("png")) {
            return "image/jpeg";
        }
        return "multipart/form-data";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String uploadFile(MultipartFile file, OssModel ossModel, FileKey fileKey) {
        String fileName = String.format("%s.%s", UUID.randomUUID().toString(), FilenameUtils.getExtension((String)file.getOriginalFilename()));
        try (InputStream inputStream = file.getInputStream();){
            ObjectMetadata objectMetadata = new ObjectMetadata();
            objectMetadata.setContentLength((long)inputStream.available());
            objectMetadata.setCacheControl("no-cache");
            objectMetadata.setHeader("Pragma", (Object)"no-cache");
            objectMetadata.setContentType(FilenameUtils.getExtension((String)("." + file.getOriginalFilename())));
            objectMetadata.setContentDisposition("inline;filename=" + fileName);
            AliOss.getOssClient(ossModel).putObject(ossModel.getBucketName(), fileKey.getDir() + "/" + fileName, inputStream, objectMetadata);
            String string = fileKey.getDir() + "/" + fileName;
            return string;
        }
        catch (OSSException oe) {
            throw new OssException(oe.getMessage());
        }
        catch (ClientException | IOException ce) {
            throw new OssException(ce.getMessage());
        }
    }

    private static String getFileUrl(String fileUrl, FileKey fileKey, OssModel ossModel) {
        if (ParamUtil.paramIsEmpty(fileUrl)) {
            throw new RuntimeException("\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a!");
        }
        String[] split = ParamUtil.split(fileUrl, "/");
        if (ParamUtil.paramIsEmpty(split)) {
            throw new OssException(HttpStatus.INVALID_PARAMETER.getMsg());
        }
        URL url = AliOss.getOssClient(ossModel).generatePresignedUrl(ossModel.getBucketName(), fileKey.getDir() + "/" + split[split.length - 1], TimeUtil.addDay(new Date(), 365));
        if (url == null) {
            throw new RuntimeException("\u83b7\u53d6OSS\u6587\u4ef6URL\u5931\u8d25!");
        }
        return url.toString();
    }

    private static String getPathUrl(String fileName, OssModel ossModel) {
        return fileName.substring(fileName.indexOf(ossModel.getEndPoint()) + ossModel.getEndPoint().length() + 1);
    }

    public static boolean delete(List<String> urls, OssModel ossModel) {
        List urlList = urls.stream().map(e -> AliOss.getPathUrl(e, ossModel)).collect(Collectors.toList());
        try {
            AliOss.getOssClient(ossModel).deleteObjects(new DeleteObjectsRequest(ossModel.getBucketName()).withKeys(urlList));
            return true;
        }
        catch (OSSException oe) {
            throw new OssException(oe.getMessage());
        }
        catch (ClientException ce) {
            throw new OssException(ce.getMessage());
        }
    }

    public static String upload(MultipartFile file, FileKey fileKey, OssModel ossModel) {
        AliOss.createBucket(ossModel);
        String fileName = AliOss.uploadFile(file, ossModel, fileKey);
        String fileOssUrl = AliOss.getFileUrl(fileName, fileKey, ossModel);
        int firstChar = fileOssUrl.indexOf("?");
        if (firstChar > 0) {
            fileOssUrl = fileOssUrl.substring(0, firstChar);
        }
        return fileOssUrl;
    }

    public static enum FileKey {
        IMAGES("images"),
        VIDEO("video");

        private String dir;

        private FileKey(String dir) {
            this.dir = dir;
        }

        public String getDir() {
            return this.dir;
        }
    }
}

