/*
 * Decompiled with CFR 0.152.
 */
package com.gjing.utils.result;

import com.gjing.enums.HttpStatus;
import com.gjing.utils.ParamUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResultVo<T> {
    private Integer code;
    private String msg;
    private T data;

    public static ResultVo success(String msg, Object data) {
        return ResultVo.builder().code(HttpStatus.OK.getCode()).msg(msg).data(data).build();
    }

    public static ResultVo success() {
        return ResultVo.builder().code(HttpStatus.OK.getCode()).msg(HttpStatus.OK.getMsg()).build();
    }

    public static ResultVo success(Object data) {
        return ResultVo.builder().code(HttpStatus.OK.getCode()).msg(HttpStatus.OK.getMsg()).data(data).build();
    }

    public static ResultVo error(Integer code, String msg) {
        return ResultVo.builder().code(code).msg(msg).build();
    }

    public static ResultVo error() {
        return ResultVo.builder().code(HttpStatus.BAD_REQUEST.getCode()).msg(HttpStatus.BAD_REQUEST.getMsg()).build();
    }

    public static ResultVo error(String msg) {
        return ResultVo.builder().code(HttpStatus.BAD_REQUEST.getCode()).msg(msg).build();
    }

    public static Map<String, Object> find(List<String> keys, List<Object> val) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), val.get(i));
        }
        return map;
    }

    public static Map<String, Object> login(String isLogin, List<String> keys, List<Object> values) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        if (ParamUtil.paramIsNotEmpty(isLogin)) {
            map.put("code", HttpStatus.OK.getCode());
            map.put("msg", HttpStatus.OK.getMsg());
        } else {
            map.put("code", HttpStatus.NO_LOGIN.getCode());
            map.put("msg", HttpStatus.NO_LOGIN.getMsg());
        }
        if (keys != null && values != null) {
            for (int i = 0; i < keys.size(); ++i) {
                map.put(keys.get(i), values.get(i));
            }
        }
        return map;
    }

    ResultVo(Integer code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public static <T> ResultVoBuilder<T> builder() {
        return new ResultVoBuilder();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public static class ResultVoBuilder<T> {
        private Integer code;
        private String msg;
        private T data;

        ResultVoBuilder() {
        }

        public ResultVoBuilder<T> code(Integer code) {
            this.code = code;
            return this;
        }

        public ResultVoBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public ResultVoBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public ResultVo<T> build() {
            return new ResultVo<T>(this.code, this.msg, this.data);
        }

        public String toString() {
            return "ResultVo.ResultVoBuilder(code=" + this.code + ", msg=" + this.msg + ", data=" + this.data + ")";
        }
    }
}

