/*
 * Decompiled with CFR 0.152.
 */
package com.gjing.utils.http;

import com.gjing.config.HttpsClientRequestFactory;
import com.gjing.enums.HttpStatus;
import com.gjing.enums.RequestEnum;
import com.gjing.ex.HttpException;
import com.gjing.utils.ParamUtil;
import com.gjing.utils.http.HttpModel;
import com.gjing.utils.http.UrlUtil;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private RestTemplate restTemplate;

    public String get(HttpModel httpModel) {
        if (!ParamUtil.multiParamHasEmpty(Arrays.asList(httpModel.getProxyIp(), httpModel.getProxyPort()))) {
            this.setProxy(httpModel.getProxyIp(), httpModel.getProxyPort());
        }
        try {
            this.checkRequestType(httpModel);
            if (ParamUtil.paramIsNotEmpty(httpModel.getHeaders())) {
                HttpHeaders httpHeaders = new HttpHeaders();
                for (String s : httpModel.getHeaders().keySet()) {
                    httpHeaders.add(s, ((List)httpModel.getHeaders().get((Object)s)).toString());
                }
                HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
                if (ParamUtil.paramIsNotEmpty(httpModel.getParams())) {
                    return (String)this.restTemplate.exchange(UrlUtil.urlAppend(httpModel.getRequestUrl(), httpModel.getParams().toSingleValueMap()), HttpMethod.GET, httpEntity, String.class, httpModel.getParams().toSingleValueMap()).getBody();
                }
                return (String)this.restTemplate.exchange(httpModel.getRequestUrl(), HttpMethod.GET, httpEntity, String.class, new Object[0]).getBody();
            }
            if (ParamUtil.paramIsNotEmpty(httpModel.getParams())) {
                return (String)this.restTemplate.getForObject(UrlUtil.urlAppend(httpModel.getRequestUrl(), httpModel.getParams().toSingleValueMap()), String.class, httpModel.getParams().toSingleValueMap());
            }
            return (String)this.restTemplate.getForObject(httpModel.getRequestUrl(), String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HttpException(HttpStatus.BAD_REQUEST.getMsg());
        }
    }

    public String post(HttpModel httpModel) {
        if (!ParamUtil.multiParamHasEmpty(Arrays.asList(httpModel.getProxyIp(), httpModel.getProxyPort()))) {
            this.setProxy(httpModel.getProxyIp(), httpModel.getProxyPort());
        }
        try {
            this.checkRequestType(httpModel);
            if (ParamUtil.paramIsNotEmpty(httpModel.getHeaders())) {
                HttpHeaders httpHeaders = new HttpHeaders();
                for (String s : httpModel.getHeaders().keySet()) {
                    httpHeaders.add(s, ((List)httpModel.getHeaders().get((Object)s)).toString());
                }
                HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
                if (ParamUtil.paramIsNotEmpty(httpModel.getParams())) {
                    httpEntity = new HttpEntity(httpModel.getParams(), (MultiValueMap)httpHeaders);
                }
                return (String)this.restTemplate.exchange(httpModel.getRequestUrl(), HttpMethod.POST, httpEntity, String.class, new Object[0]).getBody();
            }
            if (ParamUtil.paramIsNotEmpty(httpModel.getParams())) {
                return (String)this.restTemplate.postForEntity(httpModel.getRequestUrl(), httpModel.getParams(), String.class, new Object[0]).getBody();
            }
            return (String)this.restTemplate.postForEntity(httpModel.getRequestUrl(), (Object)HttpMethod.POST, String.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HttpException(e.getCause().getMessage());
        }
    }

    private void checkRequestType(HttpModel httpModel) {
        String[] urlArr = ParamUtil.split(httpModel.getRequestUrl(), ":");
        if (ParamUtil.paramIsNotEmpty(urlArr)) {
            if (Objects.equals(ParamUtil.toLowerCase(urlArr[0]), RequestEnum.HTTP.getType())) {
                this.restTemplate = new RestTemplate();
            } else if (Objects.equals(ParamUtil.toLowerCase(urlArr[0]), RequestEnum.HTTPS.getType())) {
                this.restTemplate = new RestTemplate((ClientHttpRequestFactory)new HttpsClientRequestFactory());
            } else {
                throw new HttpException("The requested url is malformed");
            }
        }
    }

    private void setProxy(String proxyHost, String proxyPort) {
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", proxyPort);
        System.setProperty("https.proxyHost", proxyHost);
        System.setProperty("https.proxyPort", proxyPort);
    }
}

