/*
 * Decompiled with CFR 0.152.
 */
package com.gjing.utils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;

public final class ParamUtil {
    public static <T> boolean paramIsEmpty(T str) {
        if (str instanceof List) {
            return ((List)str).isEmpty();
        }
        if (str instanceof Map) {
            return ((Map)str).isEmpty();
        }
        if (str instanceof Array) {
            return Array.getLength(str) == 0;
        }
        return str == null || "".equals(str);
    }

    public static <T> boolean multiParamHasEmpty(List<T> params) {
        List paramNullList = params.stream().filter(ParamUtil::paramIsEmpty).collect(Collectors.toList());
        return !paramNullList.isEmpty();
    }

    public static boolean paramIsNotEmpty(Object str) {
        return !ParamUtil.paramIsEmpty(str);
    }

    public static String trim(String str) {
        return ParamUtil.paramIsEmpty(str) ? null : str.trim();
    }

    public static List<String> trim(List<String> list) {
        List listNonNull = list.stream().filter(ParamUtil::paramIsNotEmpty).collect(Collectors.toList());
        return listNonNull.size() <= 0 ? null : listNonNull.stream().map(ParamUtil::trim).collect(Collectors.toList());
    }

    public static String toUpperCase(@NonNull String str) {
        return ParamUtil.paramIsEmpty(str) ? null : str.toUpperCase();
    }

    public static String toLowerCase(@NonNull String str) {
        return ParamUtil.paramIsEmpty(str) ? null : str.toLowerCase();
    }

    public static String removeSymbol(String str, String symbol) {
        if (ParamUtil.paramIsEmpty(str)) {
            return null;
        }
        str = ParamUtil.removeStartSymbol(str, symbol);
        return ParamUtil.removeEndSymbol(str, symbol);
    }

    public static String removeStartSymbol(String str, String symbol) {
        int strLen;
        if (ParamUtil.paramIsNotEmpty(str) && (strLen = str.length()) != 0) {
            int start;
            if (ParamUtil.paramIsEmpty(symbol)) {
                return ParamUtil.trim(str);
            }
            for (start = 0; start != strLen && symbol.indexOf(str.charAt(start)) != -1; ++start) {
            }
            return str.substring(start);
        }
        return ParamUtil.trim(str);
    }

    public static String removeEndSymbol(String str, String symbol) {
        int end;
        if (ParamUtil.paramIsNotEmpty(str) && (end = str.length()) != 0) {
            if (ParamUtil.paramIsEmpty(symbol)) {
                return ParamUtil.trim(str);
            }
            while (end != 0 && symbol.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
            return str.substring(0, end);
        }
        return ParamUtil.trim(str);
    }

    public static String[] split(String str, String symbol) {
        if (ParamUtil.paramIsEmpty(str) || symbol.length() != 1) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        while (i < str.length()) {
            if (String.valueOf(str.charAt(i)).equals(symbol)) {
                list.add(str.substring(start, i));
                start = ++i;
                continue;
            }
            ++i;
        }
        list.add(str.substring(start));
        return list.toArray(new String[0]);
    }

    public static boolean contains(String[] t, String u) {
        if (t.length < 1) {
            return false;
        }
        if (ParamUtil.paramIsEmpty(u)) {
            return false;
        }
        for (String t1 : t) {
            if (!t1.equals(u)) continue;
            return true;
        }
        return false;
    }
}

