/*
 * Decompiled with CFR 0.152.
 */
package com.gjing.utils.http;

import com.gjing.config.HttpsClientRequestFactory;
import com.gjing.enums.HttpStatus;
import com.gjing.enums.RequestEnum;
import com.gjing.ex.HttpException;
import com.gjing.utils.Gj;
import com.gjing.utils.http.RestModel;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private RestTemplate restTemplate;

    public String get(RestModel restModel) {
        if (!Gj.multiParamHasEmpty(Arrays.asList(restModel.getProxyIp(), restModel.getProxyPort()))) {
            this.setProxy(restModel.getProxyIp(), restModel.getProxyPort());
        }
        try {
            this.checkRequestType(restModel);
            if (Gj.paramIsNotEmpty(restModel.getHeaders())) {
                HttpHeaders httpHeaders = new HttpHeaders();
                for (String s : restModel.getHeaders().keySet()) {
                    httpHeaders.add(s, ((List)restModel.getHeaders().get((Object)s)).toString());
                }
                HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
                if (Gj.paramIsNotEmpty(restModel.getParams())) {
                    return (String)this.restTemplate.exchange(Gj.urlAppend(restModel.getRequestUrl(), restModel.getParams().toSingleValueMap()), HttpMethod.GET, httpEntity, String.class, restModel.getParams().toSingleValueMap()).getBody();
                }
                return (String)this.restTemplate.exchange(restModel.getRequestUrl(), HttpMethod.GET, httpEntity, String.class, new Object[0]).getBody();
            }
            if (Gj.paramIsNotEmpty(restModel.getParams())) {
                return (String)this.restTemplate.getForObject(Gj.urlAppend(restModel.getRequestUrl(), restModel.getParams().toSingleValueMap()), String.class, restModel.getParams().toSingleValueMap());
            }
            return (String)this.restTemplate.getForObject(restModel.getRequestUrl(), String.class, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HttpException(HttpStatus.BAD_REQUEST.getMsg());
        }
    }

    public String post(RestModel restModel) {
        if (!Gj.multiParamHasEmpty(Arrays.asList(restModel.getProxyIp(), restModel.getProxyPort()))) {
            this.setProxy(restModel.getProxyIp(), restModel.getProxyPort());
        }
        try {
            this.checkRequestType(restModel);
            if (Gj.paramIsNotEmpty(restModel.getHeaders())) {
                HttpHeaders httpHeaders = new HttpHeaders();
                for (String s : httpHeaders.keySet()) {
                    httpHeaders.add(s, ((List)restModel.getHeaders().get((Object)s)).toString());
                }
                HttpEntity httpEntity = new HttpEntity(null, (MultiValueMap)httpHeaders);
                if (Gj.paramIsNotEmpty(restModel.getParams())) {
                    httpEntity = new HttpEntity(restModel.getParams(), (MultiValueMap)httpHeaders);
                }
                return (String)this.restTemplate.exchange(restModel.getRequestUrl(), HttpMethod.POST, httpEntity, String.class, new Object[0]).getBody();
            }
            if (Gj.paramIsNotEmpty(restModel.getParams())) {
                return (String)this.restTemplate.postForEntity(restModel.getRequestUrl(), restModel.getParams(), String.class, new Object[0]).getBody();
            }
            return (String)this.restTemplate.postForEntity(restModel.getRequestUrl(), (Object)HttpMethod.POST, String.class, new Object[0]).getBody();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new HttpException(e.getCause().getMessage());
        }
    }

    private void checkRequestType(RestModel restModel) {
        String[] urlArr = Gj.split(restModel.getRequestUrl(), ":");
        if (Gj.paramIsNotEmpty(urlArr)) {
            if (Objects.equals(Gj.toLowerCase(urlArr[0]), RequestEnum.HTTP.getType())) {
                this.restTemplate = new RestTemplate();
            } else if (Objects.equals(Gj.toLowerCase(urlArr[0]), RequestEnum.HTTPS.getType())) {
                this.restTemplate = new RestTemplate((ClientHttpRequestFactory)new HttpsClientRequestFactory());
            } else {
                throw new HttpException("The requested url is malformed");
            }
        }
    }

    private void setProxy(String proxyHost, String proxyPort) {
        System.setProperty("http.proxyHost", proxyHost);
        System.setProperty("http.proxyPort", proxyPort);
        System.setProperty("https.proxyHost", proxyHost);
        System.setProperty("https.proxyPort", proxyPort);
    }
}

