/*
 * Decompiled with CFR 0.152.
 */
package com.gjing.utils;

import com.gjing.utils.excel.ExportExcel;
import java.lang.reflect.Array;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.servlet.http.HttpServletResponse;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;

public final class Gj {
    public static boolean paramIsEmpty(Object str) {
        if (str instanceof List) {
            return ((List)str).isEmpty();
        }
        if (str instanceof Map) {
            return ((Map)str).isEmpty();
        }
        if (str instanceof Array) {
            return Array.getLength(str) == 0;
        }
        return str == null || "".equals(str);
    }

    public static <T> boolean multiParamHasEmpty(List<T> params) {
        List paramNullList = params.stream().filter(Gj::paramIsEmpty).collect(Collectors.toList());
        return !paramNullList.isEmpty();
    }

    public static boolean paramIsNotEmpty(Object str) {
        return !Gj.paramIsEmpty(str);
    }

    public static String trim(String str) {
        return Gj.paramIsEmpty(str) ? null : str.trim();
    }

    public static List<String> trim(List<String> list) {
        List listNonNull = list.stream().filter(Gj::paramIsNotEmpty).collect(Collectors.toList());
        return listNonNull.size() <= 0 ? null : listNonNull.stream().map(Gj::trim).collect(Collectors.toList());
    }

    public static String toUpperCase(@NonNull String str) {
        return Gj.paramIsEmpty(str) ? null : str.toUpperCase();
    }

    public static String toLowerCase(@NonNull String str) {
        return Gj.paramIsEmpty(str) ? null : str.toLowerCase();
    }

    public static String removeSymbol(String str, @Nullable String symbol) {
        if (Gj.paramIsEmpty(str)) {
            return null;
        }
        str = Gj.removeStartSymbol(str, symbol);
        return Gj.removeEndSymbol(str, symbol);
    }

    public static String removeStartSymbol(String str, String symbol) {
        int strLen;
        if (Gj.paramIsNotEmpty(str) && (strLen = str.length()) != 0) {
            int start;
            if (Gj.paramIsEmpty(symbol)) {
                return Gj.trim(str);
            }
            for (start = 0; start != strLen && symbol.indexOf(str.charAt(start)) != -1; ++start) {
            }
            return str.substring(start);
        }
        return Gj.trim(str);
    }

    public static String removeEndSymbol(String str, String symbol) {
        int end;
        if (Gj.paramIsNotEmpty(str) && (end = str.length()) != 0) {
            if (Gj.paramIsEmpty(symbol)) {
                return Gj.trim(str);
            }
            while (end != 0 && symbol.indexOf(str.charAt(end - 1)) != -1) {
                --end;
            }
            return str.substring(0, end);
        }
        return Gj.trim(str);
    }

    public static String[] split(String str, String symbol) {
        if (Gj.paramIsEmpty(str) || symbol.length() != 1) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        while (i < str.length()) {
            if (String.valueOf(str.charAt(i)).equals(symbol)) {
                list.add(str.substring(start, i));
                start = ++i;
                continue;
            }
            ++i;
        }
        list.add(str.substring(start));
        return list.toArray(new String[0]);
    }

    public static String md5(@NonNull String body) {
        StringBuilder buf = new StringBuilder();
        try {
            byte[] b;
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(body.getBytes());
            for (int n : b = md.digest()) {
                int i = n;
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        return buf.toString();
    }

    public static String sha256Hmac(String str, String secret) {
        String hash = "";
        try {
            Mac sha256Hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes(), "HmacSHA256");
            sha256Hmac.init(secretKey);
            byte[] bytes = sha256Hmac.doFinal(str.getBytes());
            hash = Gj.byteArrayToHexString(bytes);
        }
        catch (Exception e) {
            System.out.println("Error HmacSHA256 ====" + e.getMessage());
        }
        return hash;
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder hs = new StringBuilder();
        for (int n = 0; b != null && n < b.length; ++n) {
            String stmp = Integer.toHexString(b[n] & 0xFF);
            if (stmp.length() == 1) {
                hs.append('0');
            }
            hs.append(stmp);
        }
        return hs.toString().toLowerCase();
    }

    public static void excelExport(HttpServletResponse response, List<Object[]> list, String[] headers, String title, @Nullable String info) {
        ExportExcel.generateHaveExcelName(response, list, headers, title, info);
    }

    public static boolean contains(String[] t, String u) {
        if (t.length < 1) {
            return false;
        }
        if (Gj.paramIsEmpty(u)) {
            return false;
        }
        for (String t1 : t) {
            if (!t1.equals(u)) continue;
            return true;
        }
        return false;
    }

    public static String getDateAsString(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public static String getDateAsString(Date date, String format) {
        SimpleDateFormat format1 = new SimpleDateFormat(format);
        return format1.format(format);
    }

    public static Date getDate(String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.parse(date);
    }

    public static Date getDate(String date, String format) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.parse(date);
    }

    public static Calendar dateToCalendar(String str) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(simpleDateFormat.parse(str));
        return calendar;
    }

    public static String urlAppend(String url, MultiValueMap<String, String> map) {
        StringBuilder builder = new StringBuilder();
        builder.append(url).append("?");
        for (String s : map.keySet()) {
            if (map.size() == 1) {
                builder.append(s).append("=").append("{").append(s).append("}");
                continue;
            }
            builder.append(s).append("=").append("{").append(s).append("}&");
        }
        return builder.toString().substring(0, builder.toString().length() - 1);
    }

    public static String urlAppend(String url, Map<String, Object> map) {
        StringBuilder builder = new StringBuilder();
        builder.append(url).append("?");
        for (String s : map.keySet()) {
            if (map.size() == 1) {
                builder.append(s).append("=").append("{").append(s).append("}");
                continue;
            }
            builder.append(s).append("=").append("{").append(s).append("}&");
        }
        if (map.size() == 1) {
            return builder.toString();
        }
        return builder.toString().substring(0, builder.toString().length() - 1);
    }
}

