/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.swagger.core;

import cn.gjing.tools.swagger.Doc;
import cn.gjing.tools.swagger.DocContact;
import cn.gjing.tools.swagger.PathType;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.annotation.Resource;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpMethod;
import org.springframework.util.AntPathMatcher;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.RequestParameterBuilder;
import springfox.documentation.builders.ResponseBuilder;
import springfox.documentation.oas.annotations.EnableOpenApi;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;

@EnableOpenApi
class SingleDocumentHandler {
    @Resource
    private Doc doc;
    @Resource
    private DocContact contact;

    SingleDocumentHandler() {
    }

    @Bean
    public ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.doc.getTitle()).description(this.doc.getDescription()).version(this.doc.getVersion()).contact(new Contact(this.contact.getName(), this.contact.getUrl(), this.contact.getEmail())).license(this.doc.getLicense()).licenseUrl(this.doc.getLicenseUrl()).termsOfServiceUrl(this.doc.getTermsOfServiceUrl()).build();
    }

    @Bean
    public Docket restApiDocket() {
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).enable(this.doc.isEnable()).groupName(this.doc.getGroup()).protocols(this.doc.getProtocols());
        if (!this.doc.getGlobalResponseSchemas().isEmpty()) {
            ArrayList responseMessageList = new ArrayList();
            this.doc.getGlobalResponseSchemas().forEach(e -> responseMessageList.add(new ResponseBuilder().code(e.getCode()).description(e.getMessage()).isDefault(e.isDefault()).build()));
            docket.globalResponses(HttpMethod.GET, responseMessageList).globalResponses(HttpMethod.DELETE, responseMessageList).globalResponses(HttpMethod.POST, responseMessageList).globalResponses(HttpMethod.PUT, responseMessageList).globalResponses(HttpMethod.PATCH, responseMessageList);
        }
        if (!this.doc.getGlobalParameters().isEmpty()) {
            ArrayList parameterList = new ArrayList();
            this.doc.getGlobalParameters().forEach(e -> parameterList.add(new RequestParameterBuilder().description(e.getDesc()).name(e.getName()).parameterIndex(e.getIndex()).deprecated(Boolean.valueOf(e.isDeprecated())).hidden(Boolean.valueOf(e.isHidden())).in(e.getType()).required(Boolean.valueOf(e.isRequired())).build()));
            docket.globalRequestParameters(parameterList);
        }
        ApiSelectorBuilder builder = docket.select();
        if (this.doc.getBasePackage().isEmpty()) {
            LoggerFactory.getLogger(SingleDocumentHandler.class).warn("Swagger basePackage value is default , Please set your own project interface path");
            builder.apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class));
        } else {
            builder.apis(RequestHandlerSelectors.basePackage((String)this.doc.getBasePackage()));
        }
        if (this.doc.getPathType() == PathType.ANT) {
            builder.paths(PathSelectors.ant((String)this.doc.getPathPattern()));
            for (String exclude : this.doc.getExcludePattern()) {
                builder.paths(SingleDocumentHandler.notAnt(exclude));
            }
        } else {
            builder.paths(PathSelectors.regex((String)this.doc.getPathPattern()));
            for (String exclude : this.doc.getExcludePattern()) {
                builder.paths(SingleDocumentHandler.notRegex(exclude));
            }
        }
        return builder.build();
    }

    public static Predicate<String> notAnt(String antPattern) {
        return input -> {
            AntPathMatcher matcher = new AntPathMatcher();
            return !matcher.match(antPattern, input);
        };
    }

    public static Predicate<String> notRegex(String pathRegex) {
        return input -> !input.matches(pathRegex);
    }
}

