/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.swagger.core;

import cn.gjing.tools.swagger.Contact;
import cn.gjing.tools.swagger.SwaggerBean;
import cn.gjing.tools.swagger.core.PathSelectContext;
import cn.gjing.tools.swagger.core.VerifyParam;
import com.google.common.base.Predicates;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.RequestMethod;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.builders.ResponseMessageBuilder;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
class SwaggerConfig {
    @Resource
    private SwaggerBean swaggerBean;
    @Resource
    private Contact contact;

    SwaggerConfig() {
    }

    @Bean
    public Docket createRestApi() {
        PathSelectContext pathSelectContext = new PathSelectContext();
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).enable(this.swaggerBean.isEnable());
        if (!this.swaggerBean.getGlobalResponseSchemas().isEmpty()) {
            ArrayList responseMessageList = new ArrayList();
            this.swaggerBean.getGlobalResponseSchemas().forEach(e -> responseMessageList.add(new ResponseMessageBuilder().code(e.getCode().intValue()).message(e.getMessage()).responseModel((ModelReference)new ModelRef(e.getSchema())).build()));
            docket.globalResponseMessage(RequestMethod.GET, responseMessageList).globalResponseMessage(RequestMethod.DELETE, responseMessageList).globalResponseMessage(RequestMethod.POST, responseMessageList).globalResponseMessage(RequestMethod.PUT, responseMessageList).globalResponseMessage(RequestMethod.PATCH, responseMessageList);
        }
        if (!this.swaggerBean.getGlobalHeaders().isEmpty()) {
            ArrayList parameterList = new ArrayList();
            this.swaggerBean.getGlobalHeaders().forEach(e -> parameterList.add(new ParameterBuilder().name(e.getName()).description(e.getDescription()).required(e.isRequired()).modelRef((ModelReference)new ModelRef("String")).parameterType("header").build()));
            docket.globalOperationParameters(parameterList);
        }
        ApiSelectorBuilder builder = docket.select();
        builder.paths(pathSelectContext.getPredicate(this.swaggerBean, this.swaggerBean.getPathPattern())).build();
        if (VerifyParam.isDefault(this.swaggerBean.getBasePackage())) {
            builder.apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class));
        } else {
            builder.apis(RequestHandlerSelectors.basePackage((String)this.swaggerBean.getBasePackage()));
        }
        for (String exclude : this.swaggerBean.getExcludePattern()) {
            builder.paths(Predicates.not(pathSelectContext.getPredicate(this.swaggerBean, exclude)));
        }
        return builder.build();
    }

    @Bean
    public ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swaggerBean.getTitle()).description(this.swaggerBean.getDescription()).version(this.swaggerBean.getVersion()).contact(new springfox.documentation.service.Contact(this.contact.getName(), this.contact.getUrl(), this.contact.getEmail())).license(this.swaggerBean.getLicense()).licenseUrl(this.swaggerBean.getLicenseUrl()).termsOfServiceUrl(this.swaggerBean.getTermsOfServiceUrl()).build();
    }
}

