/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.swagger.core;

import cn.gjing.tools.swagger.SwaggerResources;
import cn.gjing.tools.swagger.SwaggerService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.util.StringUtils;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Primary
class ResourcesRegister
implements SwaggerResourcesProvider {
    private static final String SWAGGER_PATH = "/v2/api-docs";
    @Value(value="${spring.application.name:default}")
    private String applicationName;
    @Resource
    private SwaggerResources swaggerResources;

    ResourcesRegister() {
    }

    public List<SwaggerResource> get() {
        ArrayList<SwaggerResource> resourceList = new ArrayList<SwaggerResource>();
        List<Map<String, SwaggerService>> applicationList = this.swaggerResources.getServiceList();
        if (this.swaggerResources.isEnable()) {
            if (this.swaggerResources.isRegisterMe()) {
                this.registerMe(resourceList);
            } else if (applicationList.isEmpty()) {
                throw new IllegalArgumentException("Swagger resources serveList cannot be empty, Please set register-me to true or add other serve name");
            }
            for (Map<String, SwaggerService> applicationMap : applicationList) {
                for (String serveName : applicationMap.keySet()) {
                    if (StringUtils.isEmpty((Object)serveName) || applicationMap.get(serveName).getService() == null) continue;
                    resourceList.add(this.swaggerResource(applicationMap.get(serveName).getView() == null ? serveName : applicationMap.get(serveName).getView(), ResourcesRegister.buildLocation(applicationMap.get(serveName).getService())));
                }
            }
            return resourceList;
        }
        this.registerMe(resourceList);
        return resourceList;
    }

    private SwaggerResource swaggerResource(String name, String location) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setSwaggerVersion("2.0");
        swaggerResource.setLocation(location);
        return swaggerResource;
    }

    private void registerMe(List<SwaggerResource> resourceList) {
        resourceList.add(this.swaggerResource(this.applicationName, SWAGGER_PATH));
    }

    private static String buildLocation(String name) {
        return "/" + name + SWAGGER_PATH;
    }
}

