/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.core;

import cn.gjing.Contact;
import cn.gjing.PathType;
import cn.gjing.SwaggerBean;
import cn.gjing.core.PathSelectContext;
import cn.gjing.core.VerifyParam;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.context.annotation.Bean;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.ApiSelectorBuilder;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
class SwaggerConfig {
    @Resource
    private SwaggerBean swaggerBean;
    @Resource
    private Contact contact;
    private static PathSelectContext pathSelectContext = new PathSelectContext();

    SwaggerConfig() {
    }

    @Bean
    public Docket createRestApi() {
        ApiSelectorBuilder builder = new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select();
        builder.paths(pathSelectContext.getPredicate(this.swaggerBean, this.swaggerBean.getPathPattern())).build();
        if (VerifyParam.isDefault(this.swaggerBean.getBasePackage())) {
            builder.apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class));
        } else {
            builder.apis(RequestHandlerSelectors.basePackage((String)this.swaggerBean.getBasePackage()));
        }
        for (String exclude : this.swaggerBean.getExcludePattern()) {
            if (this.swaggerBean.getPathType().equals((Object)PathType.ALL)) {
                builder.paths(Predicates.not((Predicate)PathSelectors.regex((String)exclude)));
                continue;
            }
            builder.paths(Predicates.not(pathSelectContext.getPredicate(this.swaggerBean, exclude)));
        }
        return builder.build();
    }

    @Bean
    public ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swaggerBean.getTitle()).description(this.swaggerBean.getDescription()).version(this.swaggerBean.getVersion()).contact(new springfox.documentation.service.Contact(this.contact.getName(), this.contact.getUrl(), this.contact.getEmail())).license(this.swaggerBean.getLicense()).licenseUrl(this.swaggerBean.getLicenseUrl()).termsOfServiceUrl(this.swaggerBean.getTermsOfServiceUrl()).build();
    }
}

