/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.core;

import cn.gjing.Resources;
import cn.gjing.Serve;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.util.StringUtils;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Primary
class ResourcesConfig
implements SwaggerResourcesProvider {
    private static final String SWAGGER_PATH = "/v2/api-docs";
    @Value(value="${spring.application.name:default}")
    private String applicationName;
    @Resource
    private Resources resources;

    ResourcesConfig() {
    }

    public List<SwaggerResource> get() {
        ArrayList<SwaggerResource> resourceList = new ArrayList<SwaggerResource>();
        List<Map<String, Serve>> serveList = this.resources.getServeList();
        if (this.resources.isEnable()) {
            if (this.resources.isRegisterMe()) {
                this.registerMe(resourceList);
            } else if (serveList.isEmpty()) {
                throw new IllegalArgumentException("Swagger resources serveList cannot be empty, Please set register-me to true or add other serve name");
            }
            for (Map<String, Serve> serveMap : serveList) {
                for (String serveName : serveMap.keySet()) {
                    if (StringUtils.isEmpty((Object)serveName) || serveMap.get(serveName).getLocation() == null) continue;
                    resourceList.add(this.swaggerResource(serveMap.get(serveName).getName() == null ? serveName : serveMap.get(serveName).getName(), ResourcesConfig.buildLocation(serveMap.get(serveName).getLocation())));
                }
            }
            return resourceList;
        }
        this.registerMe(resourceList);
        return resourceList;
    }

    private SwaggerResource swaggerResource(String name, String location) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setSwaggerVersion("2.0");
        swaggerResource.setLocation(location);
        return swaggerResource;
    }

    private void registerMe(List<SwaggerResource> resourceList) {
        resourceList.add(this.swaggerResource(this.applicationName, SWAGGER_PATH));
    }

    private static String buildLocation(String name) {
        if (name.endsWith(SWAGGER_PATH)) {
            return name;
        }
        return "/" + name + SWAGGER_PATH;
    }
}

