/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.core;

import cn.gjing.Contact;
import cn.gjing.SwaggerBean;
import cn.gjing.core.VerifyParam;
import com.google.common.base.Predicate;
import io.swagger.annotations.ApiOperation;
import javax.annotation.Resource;
import org.springframework.context.annotation.Bean;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
class SwaggerConfig {
    @Resource
    private SwaggerBean swaggerBean;
    @Resource
    private Contact contact;

    SwaggerConfig() {
    }

    @Bean
    public Docket createRestApi(ApiInfo apiInfo) {
        Predicate predicate;
        if (this.swaggerBean.getPathType() == null) {
            predicate = PathSelectors.any();
        } else {
            switch (this.swaggerBean.getPathType()) {
                case ANT: {
                    if (this.swaggerBean.getPathPattern() == null) {
                        throw new IllegalArgumentException("Swagger PathType is ANT,So pathPattern is cannot be null");
                    }
                    predicate = PathSelectors.ant((String)this.swaggerBean.getPathPattern());
                    break;
                }
                case REGEX: {
                    if (this.swaggerBean.getPathPattern() == null) {
                        throw new IllegalArgumentException("Swagger PathType is REGEX,So pathPattern is cannot be null");
                    }
                    predicate = PathSelectors.regex((String)this.swaggerBean.getPathPattern());
                    break;
                }
                default: {
                    predicate = PathSelectors.any();
                }
            }
        }
        if (VerifyParam.verify(this.swaggerBean.getBasePackage())) {
            return new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo).select().apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(predicate).build();
        }
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo).select().apis(RequestHandlerSelectors.basePackage((String)this.swaggerBean.getBasePackage())).paths(predicate).build();
    }

    @Bean
    public ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swaggerBean.getTitle()).description(this.swaggerBean.getDescription()).version(this.swaggerBean.getVersion()).contact(new springfox.documentation.service.Contact(this.contact.getName(), this.contact.getUrl(), this.contact.getEmail())).license(this.swaggerBean.getLicense()).licenseUrl(this.swaggerBean.getLicenseUrl()).termsOfServiceUrl(this.swaggerBean.getTermsOfServiceUrl()).build();
    }
}

