/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.doc;

import cn.gjing.doc.SwaggerDoc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.util.StringUtils;
import springfox.documentation.swagger.web.SwaggerResource;
import springfox.documentation.swagger.web.SwaggerResourcesProvider;

@Primary
public class SwaggerDocConfig
implements SwaggerResourcesProvider {
    @Value(value="${spring.application.name:i-swagger}")
    private String applicationName;
    @Resource
    private SwaggerDoc swaggerDoc;

    public List<SwaggerResource> get() {
        List<Map<String, SwaggerDoc.detail>> docList = this.swaggerDoc.getDocList();
        ArrayList<SwaggerResource> resources = new ArrayList<SwaggerResource>();
        if (this.swaggerDoc.isRegisterMe()) {
            resources.add(this.swaggerResource(this.applicationName, "/v2/api-docs", "1.0"));
        } else {
            if (!this.swaggerDoc.isRegisterMe() && docList.isEmpty()) {
                throw new IllegalArgumentException("Swagger service list cannot be empty, please set register-me to true or add other services swagger path");
            }
            if (!docList.isEmpty()) {
                for (Map<String, SwaggerDoc.detail> map : docList) {
                    for (String name : map.keySet()) {
                        if (StringUtils.isEmpty((Object)name) || StringUtils.isEmpty((Object)map.get(name).getLocation())) continue;
                        resources.add(this.swaggerResource(name, map.get(name).getLocation(), map.get(name).getVersion()));
                    }
                }
            }
        }
        return resources;
    }

    private SwaggerResource swaggerResource(String name, String location, String version) {
        SwaggerResource swaggerResource = new SwaggerResource();
        swaggerResource.setName(name);
        swaggerResource.setSwaggerVersion(version);
        swaggerResource.setLocation(location);
        return swaggerResource;
    }
}

