/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.swagger;

import cn.gjing.swagger.SwaggerBean;
import cn.gjing.swagger.verifyParam;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@EnableSwagger2
public class SwaggerConfig {
    private static final Logger log = LoggerFactory.getLogger(SwaggerConfig.class);
    @Resource
    private SwaggerBean swaggerBean;

    @Bean
    public Docket createRestApi(ApiInfo apiInfo) {
        verifyParam.verify(this.swaggerBean.getBasePackage());
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(apiInfo).select().apis(RequestHandlerSelectors.basePackage((String)this.swaggerBean.getBasePackage())).paths(PathSelectors.any()).paths(Predicates.not((Predicate)PathSelectors.regex((String)"/error.*"))).build();
    }

    @Bean
    public ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.swaggerBean.getTitle()).description(this.swaggerBean.getDescription()).version(this.swaggerBean.getVersion()).build();
    }
}

