/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing;

import cn.gjing.Bean;
import cn.gjing.BeanUtil;
import cn.gjing.FeignBean;
import cn.gjing.FeignProcess;
import cn.gjing.RouteType;
import cn.gjing.UriUtil;
import com.google.gson.Gson;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Objects;
import org.springframework.http.HttpMethod;

public class FeignClientUtil<T> {
    private final Class<T> responseType;
    private final RouteType routeType;
    private final String targetAddress;
    private T result;
    private static final FeignProcess FEIGN_PROCESS = (FeignProcess)BeanUtil.getBean(Bean.FEIGN_PROCESS.getBeanName());
    private static final Gson GSON = new Gson();

    private FeignClientUtil(Class<T> responseType, RouteType routeType, String targetAddress) {
        this.responseType = Objects.requireNonNull(responseType);
        this.result = null;
        this.routeType = Objects.requireNonNull(routeType);
        this.targetAddress = Objects.requireNonNull(UriUtil.buildUrl(targetAddress));
    }

    public static <T> FeignClientUtil<T> of(Class<T> responseType, RouteType routeType, String targetAddress) {
        return new FeignClientUtil<T>(responseType, routeType, targetAddress);
    }

    public static FeignClientUtil<String> ofByName(String targetAddress) {
        return new FeignClientUtil<String>(String.class, RouteType.NAME, targetAddress);
    }

    public static FeignClientUtil<String> ofByUrl(String targetAddress) {
        return new FeignClientUtil<String>(String.class, RouteType.URL, targetAddress);
    }

    public FeignClientUtil<T> execute(HttpMethod httpMethod, Map<String, ?> queryMap, String methodPath) {
        Objects.requireNonNull(httpMethod);
        FeignBean feignBean = this.routeType.equals((Object)RouteType.URL) ? FEIGN_PROCESS.getByUrl(this.targetAddress) : FEIGN_PROCESS.getByName(this.targetAddress);
        try {
            this.request(httpMethod, queryMap, null, UriUtil.buildUrl(this.targetAddress, methodPath), feignBean);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return this;
    }

    public FeignClientUtil<T> executeByJsonEntity(Object jsonEntity, String methodPath) {
        FeignBean feignBean = this.routeType.equals((Object)RouteType.URL) ? FEIGN_PROCESS.getByUrl(this.targetAddress) : FEIGN_PROCESS.getByName(this.targetAddress);
        try {
            this.request(HttpMethod.POST, null, jsonEntity, UriUtil.buildUrl(this.targetAddress, methodPath), feignBean);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return this;
    }

    public T getResult() {
        return this.result;
    }

    private void cast(String s) {
        try {
            this.result = GSON.fromJson(s, this.responseType);
        }
        catch (Exception e) {
            this.result = s;
        }
    }

    private void request(HttpMethod httpMethod, Map<String, ?> queryMap, Object body, String url, FeignBean feignBean) throws URISyntaxException {
        switch (httpMethod) {
            case POST: {
                if (queryMap == null) {
                    if (body == null) {
                        this.cast(feignBean.post(new URI(url)));
                        break;
                    }
                    this.cast(feignBean.postByJsonEntity(new URI(url), body));
                    break;
                }
                this.cast(feignBean.post(new URI(url), queryMap));
                break;
            }
            case GET: {
                if (queryMap == null) {
                    this.cast(feignBean.get(new URI(url)));
                    break;
                }
                this.cast(feignBean.get(new URI(url), queryMap));
                break;
            }
            case DELETE: {
                if (queryMap == null) {
                    this.cast(feignBean.delete(new URI(url)));
                    break;
                }
                this.cast(feignBean.delete(new URI(url), queryMap));
                break;
            }
            case PUT: {
                if (queryMap == null) {
                    this.cast(feignBean.put(new URI(url)));
                    break;
                }
                this.cast(feignBean.put(new URI(url), queryMap));
                break;
            }
            case PATCH: {
                if (queryMap == null) {
                    this.cast(feignBean.patch(new URI(url)));
                    break;
                }
                this.cast(feignBean.patch(new URI(url), queryMap));
                break;
            }
            default: {
                throw new IllegalStateException("This type is not supported");
            }
        }
    }
}

