/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.http;

import cn.gjing.http.ConnectionFactory;
import cn.gjing.http.FallbackHelper;
import cn.gjing.http.HttpException;
import cn.gjing.http.HttpMethod;
import cn.gjing.http.Listener;
import cn.gjing.http.UrlUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;

public class HttpClient<T>
implements Closeable {
    private String requestUrl;
    private Class<T> responseType;
    private T data;
    private Map<String, String> header;
    private String paramsStr;
    private HttpMethod httpMethod;
    private HttpURLConnection connection;
    private String json;
    private BufferedWriter bufferedWriter;
    private BufferedReader bufferedReader;
    private ObjectMapper objectMapper;
    private FallbackHelper fallbackHelper;

    private HttpClient(String url, HttpMethod method, Class<T> responseType) {
        this.requestUrl = url;
        this.httpMethod = method;
        this.responseType = responseType;
        this.objectMapper = new ObjectMapper();
        this.fallbackHelper = e -> {
            throw new HttpException(e.toString());
        };
    }

    private HttpClient() {
    }

    public static <T> HttpClient<T> builder(String url, HttpMethod method, Class<T> responseType) {
        return new HttpClient<T>(url, method, responseType);
    }

    public HttpClient<T> header(Map<String, String> header) {
        Objects.requireNonNull(header, "Request Header cannot be null");
        this.header = header;
        return this;
    }

    public HttpClient<T> param(Map<String, ?> queryMap) {
        Objects.requireNonNull(queryMap, "Request parameter cannot be null");
        String paramString = this.paramsStr = UrlUtils.paramUnicodeSort(queryMap, true, false);
        if (this.httpMethod == HttpMethod.GET) {
            this.requestUrl = this.requestUrl + "?" + paramString;
        }
        this.paramsStr = paramString;
        return this;
    }

    public HttpClient<T> body(Object json) {
        if (this.httpMethod == HttpMethod.GET) {
            return this;
        }
        Objects.requireNonNull(json, "Request json cannot be null");
        try {
            this.json = json instanceof String ? json.toString() : this.objectMapper.writeValueAsString(json);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return this;
    }

    public HttpClient<T> execute() {
        ConnectionFactory connectionFactory = new ConnectionFactory(this.requestUrl);
        HttpURLConnection connection = this.requestUrl.startsWith("http") ? connectionFactory.getHttp() : connectionFactory.getHttps();
        connection.setRequestProperty("Content-type", this.json == null ? "application/x-www-form-urlencoded" : "application/json");
        try {
            connection.setRequestMethod(this.httpMethod.toString());
        }
        catch (ProtocolException e) {
            e.printStackTrace();
        }
        this.connection = connection;
        if (this.header != null) {
            this.setHeader(connection);
        }
        try {
            String line;
            if (this.httpMethod == HttpMethod.POST || this.httpMethod == HttpMethod.PUT) {
                if (this.paramsStr != null) {
                    this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), Charset.defaultCharset()));
                    this.bufferedWriter.write(this.paramsStr);
                    this.bufferedWriter.flush();
                } else if (this.json != null) {
                    this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream(), Charset.defaultCharset()));
                    this.bufferedWriter.write(this.json);
                    this.bufferedWriter.flush();
                }
            }
            StringBuilder result = new StringBuilder();
            if (connection.getResponseCode() == 200) {
                String line2;
                this.bufferedReader = new BufferedReader(new InputStreamReader(connection.getInputStream(), Charset.defaultCharset()));
                while ((line2 = this.bufferedReader.readLine()) != null) {
                    result.append(line2);
                }
                try {
                    this.data = this.objectMapper.readValue(result.toString(), this.responseType);
                }
                catch (Exception c) {
                    this.data = result.toString();
                }
                return this;
            }
            this.bufferedReader = new BufferedReader(new InputStreamReader(connection.getErrorStream(), Charset.defaultCharset()));
            while ((line = this.bufferedReader.readLine()) != null) {
                result.append(line);
            }
            this.fallbackHelper.fallBack(result.toString());
        }
        catch (IOException e) {
            this.fallbackHelper.fallBack(e.getMessage());
        }
        return this;
    }

    public HttpClient<T> fallback(FallbackHelper<?, ?> fallbackHelper) {
        this.fallbackHelper = fallbackHelper;
        return this;
    }

    public T get() {
        return this.data;
    }

    public void listener(Listener<T> resultListener) {
        resultListener.notify(this.data);
    }

    private void setHeader(HttpURLConnection urlConnection) {
        for (Map.Entry<String, String> headerEntry : this.header.entrySet()) {
            urlConnection.setRequestProperty(headerEntry.getKey(), headerEntry.getValue());
        }
    }

    @Override
    public void close() throws IOException {
        if (this.connection != null) {
            this.connection.disconnect();
        }
        if (this.bufferedReader != null) {
            this.bufferedReader.close();
        }
        if (this.bufferedWriter != null) {
            this.bufferedWriter.flush();
            this.bufferedWriter.close();
        }
    }
}

