/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

public class UrlUtil {
    public static String urlAppend(String url, Object ... params) {
        StringBuilder builder = new StringBuilder(url);
        if (url.indexOf("/", url.length() - 1) == -1) {
            builder.append("/");
        }
        for (Object param : params) {
            builder.append(param).append("/");
        }
        return builder.toString();
    }

    public static String paramUnicodeSort(Map<String, ?> paramMap, boolean urlEncode, boolean keyToLower) {
        String buff;
        try {
            ArrayList infoIds = new ArrayList(paramMap.entrySet());
            infoIds.sort(Comparator.comparing(Map.Entry::getKey));
            StringBuilder buf = new StringBuilder();
            for (Map.Entry entry : infoIds) {
                if (StringUtils.isEmpty((String)((String)entry.getKey()))) continue;
                String key = (String)entry.getKey();
                String val = String.valueOf(entry.getValue());
                if (urlEncode) {
                    val = URLEncoder.encode(val, "UTF-8");
                    key = URLEncoder.encode(key, "UTF-8");
                }
                if (keyToLower) {
                    buf.append(key.toLowerCase()).append("=").append(val);
                } else {
                    buf.append(key).append("=").append(val);
                }
                buf.append("&");
            }
            buff = buf.toString();
            if (!StringUtils.isEmpty((String)buff)) {
                buff = buff.substring(0, buff.length() - 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return buff;
    }

    public static Map<String, String> urlParamToMap(String url) {
        ConcurrentHashMap<String, String> queryPairs = new ConcurrentHashMap<String, String>(16);
        String[] param = url.split("\\?");
        if (param.length < 1) {
            return null;
        }
        String[] pairs = param[1].split("&");
        if (pairs.length < 1) {
            return null;
        }
        for (String pair : pairs) {
            int idx = pair.indexOf("=");
            try {
                String value;
                String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
                String string = value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : null;
                if (key.isEmpty()) continue;
                queryPairs.put(key, value);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return queryPairs;
    }
}

