/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing;

import cn.gjing.HttpException;
import cn.gjing.HttpMethod;
import cn.gjing.HttpsProcess;
import cn.gjing.UrlUtil;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang.StringEscapeUtils;

class HttpHandle {
    private static final Gson GSON = new Gson();

    HttpHandle() {
    }

    <T> T invokeUrl(String url, Map<String, ?> params, Map<String, ?> headers, Object body, Integer connectTimeout, Integer readTimeout, HttpMethod method, Class<T> responseType) {
        Objects.requireNonNull(connectTimeout);
        Objects.requireNonNull(readTimeout);
        if (url == null) {
            throw new NullPointerException("Url is cannot be null");
        }
        return this.execute(url, params, headers, body, connectTimeout, readTimeout, method, responseType);
    }

    private <T> T execute(String url, Map<String, ?> params, Map<String, ?> headers, Object body, Integer connectTimeout, Integer readTimeout, HttpMethod method, Class<T> responseType) {
        String line;
        StringBuilder result;
        BufferedReader br;
        BufferedWriter bw;
        HttpURLConnection conn;
        block15: {
            String paramsStr = null;
            if (params != null) {
                paramsStr = UrlUtil.paramUnicodeSort(params, true, false);
                if (method != HttpMethod.POST) {
                    assert (paramsStr != null);
                    url = url + "?" + paramsStr;
                }
            }
            conn = null;
            bw = null;
            br = null;
            URL requestUrl = new URL(url);
            if (url.split(":")[0].equals("https")) {
                SSLContext sslContext = SSLContext.getInstance("SSL");
                TrustManager[] tm = new TrustManager[]{new HttpsProcess()};
                sslContext.init(null, tm, new SecureRandom());
                SSLSocketFactory ssf = sslContext.getSocketFactory();
                HttpsURLConnection httpsConn = (HttpsURLConnection)requestUrl.openConnection();
                httpsConn.setSSLSocketFactory(ssf);
                conn = httpsConn;
            } else {
                conn = (HttpURLConnection)requestUrl.openConnection();
            }
            this.setProperty(connectTimeout, readTimeout, method, conn, body);
            this.addHeaders(conn, headers);
            if (method == HttpMethod.POST) {
                if (paramsStr != null) {
                    bw = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), Charset.defaultCharset()));
                    bw.write(paramsStr);
                    bw.flush();
                }
                if (body != null) {
                    bw = new BufferedWriter(new OutputStreamWriter(conn.getOutputStream(), Charset.defaultCharset()));
                    bw.write(body instanceof String ? body.toString() : GSON.toJson(body));
                    bw.flush();
                }
            }
            result = new StringBuilder();
            if (conn.getResponseCode() != 200) break block15;
            br = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
            while ((line = br.readLine()) != null) {
                result.append(line);
            }
            T t = this.cast(result, responseType);
            this.disConnect(conn, bw, br);
            return t;
        }
        try {
            try {
                br = new BufferedReader(new InputStreamReader(conn.getErrorStream(), Charset.defaultCharset()));
                while ((line = br.readLine()) != null) {
                    result.append(line);
                }
                throw new HttpException(this.responseError(result.toString()));
            }
            catch (Exception e) {
                throw new HttpException(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            this.disConnect(conn, bw, br);
            throw throwable;
        }
    }

    private void disConnect(HttpURLConnection conn, BufferedWriter bw, BufferedReader br) {
        try {
            if (bw != null) {
                bw.close();
            }
            if (br != null) {
                br.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private <T> T cast(StringBuilder result, Class<T> responseType) {
        try {
            return (T)GSON.fromJson(result.toString(), responseType);
        }
        catch (RuntimeException e) {
            return (T)result.toString();
        }
    }

    private String responseError(String str) {
        String s = str.substring(str.lastIndexOf("<div>")).replaceAll("<div>", "");
        return StringEscapeUtils.unescapeHtml((String)s.substring(0, s.lastIndexOf("</div>")));
    }

    private void addHeaders(HttpURLConnection conn, Map<String, ?> headers) {
        if (headers != null) {
            Set<String> headerSet = headers.keySet();
            for (String key : headerSet) {
                conn.setRequestProperty(key, String.valueOf(headers.get(key)));
            }
        }
    }

    private void setProperty(int connectTimeout, int readTimeout, HttpMethod method, HttpURLConnection conn, Object body) throws ProtocolException {
        conn.setRequestProperty("Content-type", body == null ? "application/x-www-form-urlencoded" : "application/json");
        conn.setRequestProperty("Charset", "UTF-8");
        conn.setRequestMethod(method.toString());
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setConnectTimeout(connectTimeout);
        conn.setReadTimeout(readTimeout);
    }

    static HttpHandle getInstance() {
        return Handle.httpHandle;
    }

    private static class Handle {
        private static HttpHandle httpHandle = new HttpHandle();

        private Handle() {
        }
    }
}

