package cn.gjing.tools.excel.read.listener;

import cn.gjing.tools.excel.ExcelField;
import cn.gjing.tools.excel.metadata.listener.ExcelReadListener;
import org.apache.poi.ss.usermodel.Cell;

/**
 * Empty value listener
 *
 * @author Gjing
 **/
@FunctionalInterface
public interface ExcelEmptyReadListener<R> extends ExcelReadListener {
    /**
     * When a body cell is read, if the cell does not exist or the value is empty,
     * and header is set as required in the mapping entity {@link ExcelField#required()}
     *
     * @param r      Current Java object
     * @param header Current header
     * @param cell   Current cell
     * @return Return true to continue reading the cells of that row and retain the object generated by the current row,
     *         Returning false immediately stops reading the current row and starts the next row,
     *         and deletes the objects generated by the current row
     */
    boolean readEmpty(R r, String header, Cell cell);
}
