/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.write.resolver;

import cn.gjing.tools.excel.Excel;
import cn.gjing.tools.excel.metadata.ExcelFieldProperty;
import cn.gjing.tools.excel.metadata.ExecType;
import cn.gjing.tools.excel.metadata.aware.ExcelWorkbookAware;
import cn.gjing.tools.excel.metadata.aware.ExcelWriteContextAware;
import cn.gjing.tools.excel.metadata.listener.DefaultExcelStyleListener;
import cn.gjing.tools.excel.metadata.listener.DefaultMultiHeadListener;
import cn.gjing.tools.excel.metadata.listener.ExcelWriteListener;
import cn.gjing.tools.excel.util.BeanUtils;
import cn.gjing.tools.excel.util.ParamUtils;
import cn.gjing.tools.excel.write.BigTitle;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.resolver.ExcelBaseWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public final class ExcelBindWriter
extends ExcelBaseWriter {
    public ExcelBindWriter(ExcelWriterContext context, Excel excel, HttpServletResponse response, boolean initDefaultStyle) {
        super(context, excel.windowSize(), response, initDefaultStyle, ExecType.BIND);
    }

    @Override
    protected void initStyle() {
        this.addListener(new DefaultExcelStyleListener());
    }

    public ExcelBindWriter write(List<?> data) {
        this.getClass();
        return this.write(data, "Sheet1", true, null);
    }

    public ExcelBindWriter write(List<?> data, String sheetName) {
        return this.write(data, sheetName, true, null);
    }

    public ExcelBindWriter write(List<?> data, boolean needHead) {
        this.getClass();
        return this.write(data, "Sheet1", needHead, null);
    }

    public ExcelBindWriter write(List<?> data, String sheetName, boolean needHead) {
        return this.write(data, sheetName, needHead, null);
    }

    public ExcelBindWriter write(List<?> data, Map<String, String[]> boxValues) {
        this.getClass();
        return this.write(data, "Sheet1", true, boxValues);
    }

    public ExcelBindWriter write(List<?> data, String sheetName, Map<String, String[]> boxValues) {
        return this.write(data, sheetName, true, boxValues);
    }

    public ExcelBindWriter write(List<?> data, boolean needHead, Map<String, String[]> boxValues) {
        this.getClass();
        return this.write(data, "Sheet1", needHead, boxValues);
    }

    public ExcelBindWriter write(List<?> data, String sheetName, boolean needHead, Map<String, String[]> boxValues) {
        this.createSheet(sheetName);
        if (data == null) {
            this.context.setTemplate(true);
            this.writerResolver.writeHead(needHead, boxValues);
        } else {
            this.writerResolver.writeHead(needHead, boxValues).write(data);
        }
        return this;
    }

    public ExcelBindWriter writeTitle(BigTitle bigTitle) {
        this.getClass();
        return this.writeTitle(bigTitle, "Sheet1");
    }

    public ExcelBindWriter writeTitle(BigTitle bigTitle, String sheetName) {
        if (bigTitle != null) {
            this.createSheet(sheetName);
            this.writerResolver.writeTitle(bigTitle);
        }
        return this;
    }

    public ExcelBindWriter resetExcelClass(Class<?> excelClass, String ... ignores) {
        return this.resetExcelClass(excelClass, false, false, ignores);
    }

    public ExcelBindWriter resetExcelClass(Class<?> excelClass, boolean resetListener, boolean resetAll, String ... ignores) {
        Excel excel = excelClass.getAnnotation(Excel.class);
        ParamUtils.requireNonNull(excel, "Failed to reset Excel class, the @Excel annotation was not found on the " + excelClass);
        ArrayList<ExcelFieldProperty> properties = new ArrayList<ExcelFieldProperty>();
        this.context.setExcelFields(BeanUtils.getExcelFields(excelClass, ignores, properties));
        if (resetListener) {
            this.context.setExcelClass(excelClass, resetAll);
        } else {
            this.context.setExcelClass(excelClass);
        }
        this.context.setFieldProperties(properties);
        this.context.setBodyHeight(excel.bodyHeight());
        this.context.setHeaderHeight(excel.headerHeight());
        this.context.setHeaderSeries(((ExcelFieldProperty)properties.get(0)).getValue().length);
        return this;
    }

    public ExcelBindWriter valid(boolean enable) {
        this.context.setNeedValid(enable);
        return this;
    }

    public ExcelBindWriter multiHead(boolean enable) {
        this.context.setMultiHead(enable);
        if (enable) {
            return this.addListener(new DefaultMultiHeadListener());
        }
        return this;
    }

    public ExcelBindWriter multiHead() {
        return this.multiHead(true);
    }

    @Deprecated
    public ExcelBindWriter bind(boolean enable) {
        this.context.setBind(enable);
        return this;
    }

    public ExcelBindWriter bind(String key) {
        if (!StringUtils.isEmpty((Object)key)) {
            this.context.setBind(true);
            this.context.setUniqueKey(key);
        }
        return this;
    }

    public ExcelBindWriter unbind() {
        this.context.setBind(false);
        return this;
    }

    public ExcelBindWriter temp(boolean isTemp) {
        this.nullIsTemp = isTemp;
        return this;
    }

    public ExcelBindWriter addListener(ExcelWriteListener listener) {
        this.context.addListener(listener);
        if (listener instanceof ExcelWriteContextAware) {
            ((ExcelWriteContextAware)((Object)listener)).setContext(this.context);
        }
        if (listener instanceof ExcelWorkbookAware) {
            ((ExcelWorkbookAware)((Object)listener)).setWorkbook(this.context.getWorkbook());
        }
        return this;
    }

    public ExcelBindWriter addListener(List<? extends ExcelWriteListener> listeners) {
        if (listeners != null) {
            listeners.forEach(this::addListener);
        }
        return this;
    }
}

