/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.util;

import cn.gjing.tools.excel.ExcelField;
import cn.gjing.tools.excel.metadata.ExcelFieldProperty;
import cn.gjing.tools.excel.util.ParamUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class BeanUtils {
    public static void setFieldValue(Object o, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(o, value);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Object getFieldValue(Object o, Field field) {
        try {
            field.setAccessible(true);
            return field.get(o);
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public static List<Field> getExcelFields(Class<?> excelClass, String[] ignores, List<ExcelFieldProperty> fieldProperties) {
        List<Field> fieldList = BeanUtils.getAllFields(excelClass);
        fieldList = fieldList.stream().filter(e -> e.isAnnotationPresent(ExcelField.class)).sorted(Comparator.comparing(e -> e.getAnnotation(ExcelField.class).order())).filter(e -> {
            String[] headNameArray;
            ExcelField excelField = e.getAnnotation(ExcelField.class);
            for (String name : headNameArray = excelField.value()) {
                if (!ParamUtils.contains(ignores, name)) continue;
                return false;
            }
            if (fieldProperties != null) {
                fieldProperties.add(ExcelFieldProperty.builder().value(excelField.value()).title(excelField.title()).width(excelField.width()).order(excelField.order()).format(excelField.format()).autoMerge(excelField.autoMerge().enable()).mergeEmpty(excelField.autoMerge().empty()).mergeCallback(excelField.autoMerge().callback()).convert(excelField.convert()).color(excelField.color()).fontColor(excelField.fontColor()).build());
            }
            return true;
        }).collect(Collectors.toList());
        return fieldList;
    }

    public static Map<String, Field> getExcelFieldsMap(Class<?> excelClass) {
        List<Field> fieldList = BeanUtils.getAllFields(excelClass);
        return fieldList.stream().filter(e -> e.isAnnotationPresent(ExcelField.class)).collect(Collectors.toMap(e -> {
            ExcelField excelField = e.getAnnotation(ExcelField.class);
            String[] headArray = excelField.value();
            return headArray[headArray.length - 1] + excelField.title();
        }, f -> f));
    }

    public static List<Field> getAllFields(Class<?> clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(declaredFields));
        for (Class<?> superclass = clazz.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
            fieldList.addAll(Arrays.asList(superclass.getDeclaredFields()));
        }
        return fieldList;
    }

    public static Class<?> getInterfaceType(Class<?> source, Class<?> typeInterface, int paramIndex) {
        Type[] genericInterfaces;
        for (Type type : genericInterfaces = source.getGenericInterfaces()) {
            if (!type.getTypeName().startsWith(typeInterface.getName())) continue;
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getActualTypeArguments()[paramIndex];
        }
        return null;
    }

    public static Enum<?> getEnum(Class<? extends Enum<?>> enumClass, String value) {
        Enum<?>[] enumConstants;
        for (Enum<?> constant : enumConstants = enumClass.getEnumConstants()) {
            if (!value.equals(constant.name())) continue;
            return constant;
        }
        throw new NullPointerException("Not found your enum");
    }
}

