/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.metadata;

import cn.gjing.tools.excel.metadata.annotation.ListenerNative;
import cn.gjing.tools.excel.metadata.listener.ExcelListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractExcelContext {
    protected Workbook workbook;
    protected Sheet sheet;
    protected final List<ExcelListener> listenerCache = new ArrayList<ExcelListener>();

    public void addListener(ExcelListener listener) {
        if (listener != null) {
            this.listenerCache.add(listener);
        }
    }

    protected void clearListener(boolean all, Class<?> excelClass) {
        if (all) {
            this.listenerCache.clear();
            return;
        }
        this.listenerCache.removeIf(e -> {
            ListenerNative listenerNative = e.getClass().getAnnotation(ListenerNative.class);
            if (listenerNative == null) {
                return true;
            }
            for (Class<?> aClass : listenerNative.value()) {
                if (excelClass != aClass) continue;
                return true;
            }
            return false;
        });
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public List<ExcelListener> getListenerCache() {
        return this.listenerCache;
    }
}

