/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.driven;

import cn.gjing.tools.excel.metadata.listener.ExcelWriteListener;
import cn.gjing.tools.excel.write.BigTitle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ExcelWriteWrapper {
    private List<ExcelWriteListener> writeListeners;
    private Map<String, String[]> boxValues;
    private String[] ignores;
    private String fileName;
    private final List<Object> dataList = new ArrayList<Object>();
    private String unqKey;

    private ExcelWriteWrapper() {
    }

    public static ExcelWriteWrapper build() {
        return new ExcelWriteWrapper();
    }

    public static ExcelWriteWrapper build(List<?> data) {
        return new ExcelWriteWrapper().data(data);
    }

    public static ExcelWriteWrapper build(String fileName, List<?> data) {
        return new ExcelWriteWrapper().fileName(fileName).data(data);
    }

    public static ExcelWriteWrapper build(String fileName) {
        return new ExcelWriteWrapper().fileName(fileName);
    }

    public ExcelWriteWrapper listener(ExcelWriteListener writeListener) {
        if (this.writeListeners == null) {
            this.writeListeners = new ArrayList<ExcelWriteListener>();
        }
        this.writeListeners.add(writeListener);
        return this;
    }

    public ExcelWriteWrapper listener(List<ExcelWriteListener> writeListeners) {
        if (this.writeListeners == null) {
            this.writeListeners = new ArrayList<ExcelWriteListener>();
        }
        this.writeListeners.addAll(writeListeners);
        return this;
    }

    public ExcelWriteWrapper title(BigTitle bigTitle) {
        if (bigTitle != null) {
            this.dataList.add(bigTitle);
        }
        return this;
    }

    public ExcelWriteWrapper data(List<?> data) {
        this.dataList.add(data);
        return this;
    }

    public ExcelWriteWrapper boxValue(Map<String, String[]> boxValues) {
        this.boxValues = boxValues;
        return this;
    }

    public ExcelWriteWrapper ignores(String ... ignores) {
        this.ignores = ignores;
        return this;
    }

    public ExcelWriteWrapper fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    public ExcelWriteWrapper key(String key) {
        this.unqKey = key;
        return this;
    }

    public List<ExcelWriteListener> getWriteListeners() {
        return this.writeListeners;
    }

    public Map<String, String[]> getBoxValues() {
        return this.boxValues;
    }

    public String[] getIgnores() {
        return this.ignores;
    }

    public String getFileName() {
        return this.fileName;
    }

    public List<Object> getDataList() {
        return this.dataList;
    }

    public String getUnqKey() {
        return this.unqKey;
    }
}

