/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.read.resolver;

import cn.gjing.tools.excel.ExcelField;
import cn.gjing.tools.excel.convert.DataConvert;
import cn.gjing.tools.excel.convert.DefaultDataConvert;
import cn.gjing.tools.excel.convert.ExcelDataConvert;
import cn.gjing.tools.excel.exception.ExcelAssertException;
import cn.gjing.tools.excel.exception.ExcelInitException;
import cn.gjing.tools.excel.exception.ExcelResolverException;
import cn.gjing.tools.excel.exception.ExcelTemplateException;
import cn.gjing.tools.excel.metadata.ExcelReaderResolver;
import cn.gjing.tools.excel.metadata.RowType;
import cn.gjing.tools.excel.read.ExcelReaderContext;
import cn.gjing.tools.excel.read.listener.ExcelEmptyReadListener;
import cn.gjing.tools.excel.read.listener.ExcelReadListener;
import cn.gjing.tools.excel.read.listener.ExcelRowReadListener;
import cn.gjing.tools.excel.read.valid.ExcelAssert;
import cn.gjing.tools.excel.util.BeanUtils;
import cn.gjing.tools.excel.util.ListenerChain;
import cn.gjing.tools.excel.util.ParamUtils;
import com.google.gson.Gson;
import com.monitorjbl.xlsx.impl.StreamingWorkbook;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

class ExcelReadExecutor<R>
implements ExcelReaderResolver<R> {
    private ExcelReaderContext<R> context;
    private Map<Class<? extends DataConvert<?>>, DataConvert<?>> dataConvertMap;
    private Boolean save;
    private Gson gson;

    ExcelReadExecutor() {
    }

    @Override
    public void init(ExcelReaderContext<R> readerContext) {
        this.context = readerContext;
        this.dataConvertMap = new HashMap(16);
        this.dataConvertMap.put(DefaultDataConvert.class, new DefaultDataConvert());
        this.gson = new Gson();
    }

    @Override
    public void read(int headerIndex, String sheetName) {
        if (this.context.isCheckTemplate()) {
            String key = "unq-" + sheetName;
            if (this.context.getWorkbook().getSheetIndex(key) == -1) {
                throw new ExcelTemplateException();
            }
            Iterator iterator = this.context.getWorkbook().getSheet(key).iterator();
            if (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (!ParamUtils.equals(ParamUtils.encodeMd5(this.context.getUniqueKey()), row.getCell(0).getStringCellValue(), false)) {
                    throw new ExcelTemplateException();
                }
            }
        }
        if (this.context.getWorkbook() instanceof StreamingWorkbook) {
            try {
                this.context.setSheet(this.context.getWorkbook().getSheet(sheetName));
            }
            catch (Exception e) {
                throw new ExcelResolverException("The" + sheetName + " is not found in the workbook");
            }
        } else {
            Sheet sheet = this.context.getWorkbook().getSheet(sheetName);
            if (sheet == null) {
                throw new ExcelResolverException("The" + sheetName + " is not found in the workbook");
            }
            this.context.setSheet(sheet);
        }
        this.reader(headerIndex, this.context.getResultReadListener() == null ? null : new ArrayList(), this.context.getReadListenersCache().get(ExcelRowReadListener.class), (ExpressionParser)new SpelExpressionParser(), (EvaluationContext)new StandardEvaluationContext());
    }

    private void reader(int headerIndex, List<R> dataList, List<ExcelReadListener> rowReadListeners, ExpressionParser parser, EvaluationContext context) {
        this.save = true;
        boolean stop = false;
        ListenerChain.doReadBefore(rowReadListeners, this.context);
        for (Row row : this.context.getSheet()) {
            R r;
            Object value;
            if (stop) break;
            if (row.getRowNum() < headerIndex) {
                if (!this.context.isHeadBefore()) continue;
                ArrayList<Object> otherValues = new ArrayList<Object>();
                for (Cell cell : row) {
                    value = this.getValue(null, cell, null, null, this.gson, RowType.OTHER);
                    otherValues.add(ListenerChain.doReadCell(rowReadListeners, value, null, row.getRowNum(), cell.getColumnIndex(), RowType.OTHER));
                }
                stop = ListenerChain.doReadRow(rowReadListeners, null, otherValues, row.getRowNum(), RowType.OTHER);
                continue;
            }
            if (row.getRowNum() == headerIndex) {
                for (Cell cell : row) {
                    value = cell.getStringCellValue();
                    if (ParamUtils.contains(this.context.getIgnores(), (String)value)) {
                        value = "ig";
                    }
                    this.context.getHeadNames().add(String.valueOf(ListenerChain.doReadCell(rowReadListeners, value, null, row.getRowNum(), cell.getColumnIndex(), RowType.HEAD)));
                }
                stop = ListenerChain.doReadRow(rowReadListeners, null, this.context.getHeadNames(), row.getRowNum(), RowType.HEAD);
                continue;
            }
            if (row.getRowNum() <= headerIndex) continue;
            try {
                r = this.context.getExcelClass().newInstance();
                context.setVariable(this.context.getExcelClass().getSimpleName(), r);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ExcelInitException("Excel entity init failure, " + e.getMessage());
            }
            int size = this.context.getHeadNames().size();
            for (int c = 0; c < size && this.save.booleanValue(); ++c) {
                String head = this.context.getHeadNames().get(c);
                if ("ig".equals(head)) continue;
                Field field = this.context.getExcelFieldMap().get(head);
                if (field == null) {
                    field = this.context.getExcelFieldMap().get(head + ParamUtils.numberToEn(c));
                }
                if (field == null) continue;
                ExcelField excelField = field.getAnnotation(ExcelField.class);
                Cell valueCell = row.getCell(c);
                try {
                    Object value2;
                    if (valueCell != null) {
                        value2 = this.getValue(r, valueCell, field, excelField, this.gson, RowType.BODY);
                        context.setVariable(field.getName(), value2);
                        this.assertValue(parser, context, row, c, field, excelField);
                        value2 = ListenerChain.doReadCell(rowReadListeners, value2, field, row.getRowNum(), c, RowType.BODY);
                        value2 = this.convert(field, value2, parser, context, this.createDataConvert(field, excelField));
                        if (this.save.booleanValue() && value2 != null) {
                            this.setValue(r, field, value2);
                        }
                    } else {
                        this.allowEmpty(r, field, excelField, row.getRowNum(), c);
                        context.setVariable(field.getName(), null);
                        this.assertValue(parser, context, row, c, field, excelField);
                        value2 = ListenerChain.doReadCell(rowReadListeners, null, field, row.getRowNum(), c, RowType.BODY);
                        value2 = this.convert(field, value2, parser, context, this.createDataConvert(field, excelField));
                        this.setValue(r, field, value2);
                    }
                    context.setVariable(field.getName(), value2);
                    continue;
                }
                catch (Exception e) {
                    if (e instanceof ExcelAssertException) {
                        throw (ExcelAssertException)e;
                    }
                    throw new ExcelResolverException(e.getMessage());
                }
            }
            if (!this.save.booleanValue()) continue;
            try {
                if (dataList != null) {
                    dataList.add(r);
                }
                ListenerChain.doReadRow(rowReadListeners, r, null, row.getRowNum(), RowType.BODY);
            }
            catch (Exception e) {
                throw new ExcelResolverException(e.getMessage());
            }
        }
        ListenerChain.doReadFinish(rowReadListeners, this.context);
        ListenerChain.doResultNotify(this.context.getResultReadListener(), dataList);
    }

    private Object getValue(R r, Cell cell, Field field, ExcelField excelField, Gson gson, RowType rowType) {
        switch (cell.getCellType()) {
            case _NONE: 
            case BLANK: 
            case ERROR: {
                if (rowType != RowType.BODY) break;
                this.allowEmpty(r, field, excelField, cell.getRowIndex(), cell.getColumnIndex());
                break;
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                return rowType == RowType.BODY ? gson.fromJson(gson.toJson((Object)cell.getNumericCellValue()), field.getType()) : Double.valueOf(cell.getNumericCellValue());
            }
            case FORMULA: {
                return rowType == RowType.BODY ? gson.fromJson(gson.toJson((Object)cell.getStringCellValue()), field.getType()) : cell.getStringCellValue();
            }
            default: {
                return excelField.trim() ? cell.getStringCellValue().trim() : cell.getStringCellValue();
            }
        }
        return null;
    }

    private Object convert(Field field, Object value, ExpressionParser parser, EvaluationContext context, DataConvert<?> dataConvert) {
        ExcelDataConvert excelDataConvert = field.getAnnotation(ExcelDataConvert.class);
        if (excelDataConvert != null && !"".equals(excelDataConvert.expr2())) {
            return parser.parseExpression(excelDataConvert.expr2()).getValue(context);
        }
        return dataConvert.toEntityAttribute(value, field);
    }

    private DataConvert<?> createDataConvert(Field field, ExcelField excelField) {
        DataConvert<?> dataConvert = this.dataConvertMap.get(excelField.convert());
        if (dataConvert == null) {
            try {
                dataConvert = excelField.convert().newInstance();
                this.dataConvertMap.put(excelField.convert(), dataConvert);
            }
            catch (Exception e) {
                throw new ExcelInitException("Init specified excel header data converter failure " + field.getName() + ", " + e.getMessage());
            }
        }
        return dataConvert;
    }

    private void setValue(R o, Field field, Object value) {
        try {
            BeanUtils.setFieldValue(o, field, value);
        }
        catch (RuntimeException e) {
            if (field.getType() == LocalDate.class) {
                BeanUtils.setFieldValue(o, field, LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault()).toLocalDate());
                return;
            }
            if (field.getType() == LocalDateTime.class) {
                BeanUtils.setFieldValue(o, field, LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault()));
                return;
            }
            throw new IllegalArgumentException("Unsupported data type, the current cell value type is " + value.getClass().getTypeName() + ", but " + field.getName() + " is " + field.getType().getTypeName());
        }
    }

    private void allowEmpty(R r, Field field, ExcelField excelField, int rowIndex, int colIndex) {
        if (excelField.required()) {
            this.save = ListenerChain.doReadEmpty(this.context.getReadListenersCache().get(ExcelEmptyReadListener.class), r, field, excelField, rowIndex, colIndex);
        }
    }

    private void assertValue(ExpressionParser parser, EvaluationContext context, Row row, int c, Field field, ExcelField excelField) {
        Boolean test;
        ExcelAssert excelAssert = field.getAnnotation(ExcelAssert.class);
        if (excelAssert != null && (test = (Boolean)parser.parseExpression(excelAssert.expr()).getValue(context, Boolean.class)) != null && !test.booleanValue()) {
            throw new ExcelAssertException(excelAssert.message(), excelField, field, row.getRowNum(), c);
        }
    }
}

