/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.read;

import cn.gjing.tools.excel.read.listener.ExcelReadListener;
import cn.gjing.tools.excel.read.listener.ExcelResultReadListener;
import cn.gjing.tools.excel.util.ListenerChain;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExcelReaderContext<R> {
    private Workbook workbook;
    private Sheet sheet;
    private List<String> headNames;
    private Class<R> excelClass;
    private Map<String, Field> excelFieldMap;
    private boolean checkTemplate = false;
    private boolean headBefore = false;
    private String uniqueKey;
    private String[] ignores;
    private Map<Class<? extends ExcelReadListener>, List<ExcelReadListener>> readListenersCache = new HashMap<Class<? extends ExcelReadListener>, List<ExcelReadListener>>(8);
    private ExcelResultReadListener<R> resultReadListener;

    public ExcelReaderContext(Class<R> excelClass, Map<String, Field> excelFieldMap, String[] ignores) {
        this.excelClass = excelClass;
        this.excelFieldMap = excelFieldMap;
        this.headNames = new ArrayList<String>();
        this.ignores = ignores;
    }

    public void addListener(ExcelReadListener readListener) {
        ListenerChain.addReadListener(this.readListenersCache, readListener);
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public List<String> getHeadNames() {
        return this.headNames;
    }

    public Class<R> getExcelClass() {
        return this.excelClass;
    }

    public Map<String, Field> getExcelFieldMap() {
        return this.excelFieldMap;
    }

    public boolean isCheckTemplate() {
        return this.checkTemplate;
    }

    public boolean isHeadBefore() {
        return this.headBefore;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public String[] getIgnores() {
        return this.ignores;
    }

    public Map<Class<? extends ExcelReadListener>, List<ExcelReadListener>> getReadListenersCache() {
        return this.readListenersCache;
    }

    public ExcelResultReadListener<R> getResultReadListener() {
        return this.resultReadListener;
    }

    public void setWorkbook(Workbook workbook) {
        this.workbook = workbook;
    }

    public void setSheet(Sheet sheet) {
        this.sheet = sheet;
    }

    public void setHeadNames(List<String> headNames) {
        this.headNames = headNames;
    }

    public void setExcelClass(Class<R> excelClass) {
        this.excelClass = excelClass;
    }

    public void setExcelFieldMap(Map<String, Field> excelFieldMap) {
        this.excelFieldMap = excelFieldMap;
    }

    public void setCheckTemplate(boolean checkTemplate) {
        this.checkTemplate = checkTemplate;
    }

    public void setHeadBefore(boolean headBefore) {
        this.headBefore = headBefore;
    }

    public void setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public void setIgnores(String[] ignores) {
        this.ignores = ignores;
    }

    public void setReadListenersCache(Map<Class<? extends ExcelReadListener>, List<ExcelReadListener>> readListenersCache) {
        this.readListenersCache = readListenersCache;
    }

    public void setResultReadListener(ExcelResultReadListener<R> resultReadListener) {
        this.resultReadListener = resultReadListener;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcelReaderContext)) {
            return false;
        }
        ExcelReaderContext other = (ExcelReaderContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Workbook this$workbook = this.getWorkbook();
        Workbook other$workbook = other.getWorkbook();
        if (this$workbook == null ? other$workbook != null : !this$workbook.equals(other$workbook)) {
            return false;
        }
        Sheet this$sheet = this.getSheet();
        Sheet other$sheet = other.getSheet();
        if (this$sheet == null ? other$sheet != null : !this$sheet.equals(other$sheet)) {
            return false;
        }
        List<String> this$headNames = this.getHeadNames();
        List<String> other$headNames = other.getHeadNames();
        if (this$headNames == null ? other$headNames != null : !((Object)this$headNames).equals(other$headNames)) {
            return false;
        }
        Class<R> this$excelClass = this.getExcelClass();
        Class<R> other$excelClass = other.getExcelClass();
        if (this$excelClass == null ? other$excelClass != null : !this$excelClass.equals(other$excelClass)) {
            return false;
        }
        Map<String, Field> this$excelFieldMap = this.getExcelFieldMap();
        Map<String, Field> other$excelFieldMap = other.getExcelFieldMap();
        if (this$excelFieldMap == null ? other$excelFieldMap != null : !((Object)this$excelFieldMap).equals(other$excelFieldMap)) {
            return false;
        }
        if (this.isCheckTemplate() != other.isCheckTemplate()) {
            return false;
        }
        if (this.isHeadBefore() != other.isHeadBefore()) {
            return false;
        }
        String this$uniqueKey = this.getUniqueKey();
        String other$uniqueKey = other.getUniqueKey();
        if (this$uniqueKey == null ? other$uniqueKey != null : !this$uniqueKey.equals(other$uniqueKey)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getIgnores(), other.getIgnores())) {
            return false;
        }
        Map<Class<ExcelReadListener>, List<ExcelReadListener>> this$readListenersCache = this.getReadListenersCache();
        Map<Class<ExcelReadListener>, List<ExcelReadListener>> other$readListenersCache = other.getReadListenersCache();
        if (this$readListenersCache == null ? other$readListenersCache != null : !((Object)this$readListenersCache).equals(other$readListenersCache)) {
            return false;
        }
        ExcelResultReadListener<R> this$resultReadListener = this.getResultReadListener();
        ExcelResultReadListener<R> other$resultReadListener = other.getResultReadListener();
        return !(this$resultReadListener == null ? other$resultReadListener != null : !this$resultReadListener.equals(other$resultReadListener));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExcelReaderContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Workbook $workbook = this.getWorkbook();
        result = result * 59 + ($workbook == null ? 43 : $workbook.hashCode());
        Sheet $sheet = this.getSheet();
        result = result * 59 + ($sheet == null ? 43 : $sheet.hashCode());
        List<String> $headNames = this.getHeadNames();
        result = result * 59 + ($headNames == null ? 43 : ((Object)$headNames).hashCode());
        Class<R> $excelClass = this.getExcelClass();
        result = result * 59 + ($excelClass == null ? 43 : $excelClass.hashCode());
        Map<String, Field> $excelFieldMap = this.getExcelFieldMap();
        result = result * 59 + ($excelFieldMap == null ? 43 : ((Object)$excelFieldMap).hashCode());
        result = result * 59 + (this.isCheckTemplate() ? 79 : 97);
        result = result * 59 + (this.isHeadBefore() ? 79 : 97);
        String $uniqueKey = this.getUniqueKey();
        result = result * 59 + ($uniqueKey == null ? 43 : $uniqueKey.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getIgnores());
        Map<Class<ExcelReadListener>, List<ExcelReadListener>> $readListenersCache = this.getReadListenersCache();
        result = result * 59 + ($readListenersCache == null ? 43 : ((Object)$readListenersCache).hashCode());
        ExcelResultReadListener<R> $resultReadListener = this.getResultReadListener();
        result = result * 59 + ($resultReadListener == null ? 43 : $resultReadListener.hashCode());
        return result;
    }

    public String toString() {
        return "ExcelReaderContext(workbook=" + this.getWorkbook() + ", sheet=" + this.getSheet() + ", headNames=" + this.getHeadNames() + ", excelClass=" + this.getExcelClass() + ", excelFieldMap=" + this.getExcelFieldMap() + ", checkTemplate=" + this.isCheckTemplate() + ", headBefore=" + this.isHeadBefore() + ", uniqueKey=" + this.getUniqueKey() + ", ignores=" + Arrays.deepToString(this.getIgnores()) + ", readListenersCache=" + this.getReadListenersCache() + ", resultReadListener=" + this.getResultReadListener() + ")";
    }
}

