/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.metadata;

import cn.gjing.tools.excel.exception.ExcelResolverException;
import cn.gjing.tools.excel.metadata.ExcelType;
import cn.gjing.tools.excel.write.BigTitle;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.callback.ExcelAutoMergeCallback;
import cn.gjing.tools.excel.write.listener.ExcelWriteListener;
import cn.gjing.tools.excel.write.style.ExcelStyleWriteListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class ExcelWriterResolver {
    public final ExcelWriterContext context;

    public ExcelWriterResolver(ExcelWriterContext context) {
        this.context = context;
    }

    public void writeTitle(BigTitle bigTitle) {
        List<ExcelWriteListener> cellListeners = this.context.getWriteListenerCache().get(ExcelStyleWriteListener.class);
        int startOffset = this.context.getSheet().getPhysicalNumberOfRows();
        int endOffset = startOffset + bigTitle.getLines() - 1;
        for (int i = 0; i < bigTitle.getLines(); ++i) {
            Row row = this.context.getSheet().createRow(startOffset + i);
            row.setHeight(bigTitle.getRowHeight());
            Cell cell = row.createCell(0);
            cellListeners.forEach(e -> {
                if (e instanceof ExcelStyleWriteListener) {
                    ((ExcelStyleWriteListener)e).setTitleStyle(bigTitle, cell);
                }
            });
            Object content = bigTitle.getCallback().apply(this.context.getWorkbook(), cell, bigTitle);
            if (content instanceof String) {
                cell.setCellValue((String)content);
                continue;
            }
            if (content instanceof RichTextString) {
                if ("XLSX".equals(this.context.getExcelType().name())) {
                    throw new ExcelResolverException("XLSX does not support rich text for now");
                }
                cell.setCellValue((RichTextString)content);
                continue;
            }
            throw new ExcelResolverException("Big title content type invalid, String and RichTextString are allowed!");
        }
        this.context.getSheet().addMergedRegion(new CellRangeAddress(startOffset, endOffset, bigTitle.getFirstCol(), bigTitle.getLastCol()));
    }

    public abstract void write(List<?> var1);

    public abstract void simpleWrite(List<List<Object>> var1, boolean var2, Map<String, ExcelAutoMergeCallback<?>> var3);

    public abstract ExcelWriterResolver writeHead(boolean var1, Map<String, String[]> var2);

    public abstract ExcelWriterResolver simpleWriteHead(boolean var1);

    public void flush(HttpServletResponse response, ExcelWriterContext context) {
        response.setContentType("application/vnd.ms-excel");
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        OutputStream outputStream = null;
        try {
            if (request.getHeader("User-Agent").toLowerCase().indexOf("firefox") > 0) {
                context.setFileName(new String(context.getFileName().getBytes(StandardCharsets.UTF_8), "ISO8859-1"));
            } else {
                context.setFileName(URLEncoder.encode(context.getFileName(), "UTF-8"));
            }
            response.setHeader("Content-disposition", "attachment;filename=" + context.getFileName() + (context.getExcelType() == ExcelType.XLS ? ".xls" : ".xlsx"));
            outputStream = response.getOutputStream();
            context.getWorkbook().write(outputStream);
        }
        catch (IOException e) {
            throw new ExcelResolverException("Excel cache data flush failure, " + e.getMessage());
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
                if (context.getWorkbook() != null) {
                    context.getWorkbook().close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void flushToLocal(String path, ExcelWriterContext context) {
        OutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream((path.endsWith("/") ? path : path + "/") + context.getFileName() + (context.getExcelType() == ExcelType.XLS ? ".xls" : ".xlsx"));
            context.getWorkbook().write(fileOutputStream);
        }
        catch (IOException e) {
            throw new ExcelResolverException("Excel cache data flush failure, " + e.getMessage());
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                    ((FileOutputStream)fileOutputStream).close();
                }
                if (context.getWorkbook() != null) {
                    context.getWorkbook().close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

