/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.write.resolver.core;

import cn.gjing.tools.excel.exception.ExcelResolverException;
import cn.gjing.tools.excel.metadata.ExcelType;
import cn.gjing.tools.excel.metadata.ExecType;
import cn.gjing.tools.excel.util.ExcelUtils;
import cn.gjing.tools.excel.util.ListenerChain;
import cn.gjing.tools.excel.write.BigTitle;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.resolver.core.ExcelBaseWriteExecutor;
import cn.gjing.tools.excel.write.resolver.core.ExcelBindWriterExecutor;
import cn.gjing.tools.excel.write.resolver.core.ExcelSimpleWriterExecutor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class ExcelWriterResolver {
    protected final ExcelWriterContext context;
    protected final ExcelBaseWriteExecutor writeExecutor;

    public ExcelWriterResolver(ExcelWriterContext context, ExecType execType) {
        this.context = context;
        this.writeExecutor = execType == ExecType.BIND ? new ExcelBindWriterExecutor(context) : new ExcelSimpleWriterExecutor(context);
    }

    public void writeTitle(BigTitle bigTitle) {
        if (bigTitle.getLastCol() < 1) {
            bigTitle.setLastCol(this.context.getExcelFields().size() - 1);
        }
        if (bigTitle.getLines() < 1) {
            bigTitle.setLines(1);
        }
        if (bigTitle.getFirstCol() < 0) {
            bigTitle.setFirstCol(0);
        }
        if (bigTitle.getLines() == 1 && bigTitle.getFirstCol() == bigTitle.getLastCol()) {
            throw new ExcelResolverException("Merged region must contain 2 or more cells");
        }
        int startOffset = bigTitle.getFirstRow() == -1 ? this.context.getSheet().getPhysicalNumberOfRows() : bigTitle.getFirstRow();
        int endOffset = startOffset + bigTitle.getLines() - 1;
        for (int i = 0; i < bigTitle.getLines(); ++i) {
            Row row = this.context.getSheet().getRow(startOffset + i);
            if (row == null) {
                row = this.context.getSheet().createRow(startOffset + i);
                row.setHeight(bigTitle.getRowHeight());
            }
            Cell cell = row.createCell(bigTitle.getFirstCol());
            Object content = bigTitle.getCallback().apply(this.context.getWorkbook(), bigTitle.getContent());
            if (content instanceof RichTextString) {
                if (this.context.getExcelType() == ExcelType.XLSX) {
                    throw new ExcelResolverException("XLSX does not support rich text for now");
                }
                cell.setCellValue((RichTextString)content);
            } else {
                ExcelUtils.setCellValue(cell, content);
            }
            if (i != 0) continue;
            ListenerChain.doSetTitleStyle(this.context.getListenerCache(), bigTitle, cell);
        }
        this.context.getSheet().addMergedRegion(new CellRangeAddress(startOffset, endOffset, bigTitle.getFirstCol(), bigTitle.getLastCol()));
    }

    public abstract void write(List<?> var1);

    public abstract ExcelWriterResolver writeHead(boolean var1, Map<String, String[]> var2);

    public void flush(HttpServletResponse response, ExcelWriterContext context) {
        response.setContentType("application/vnd.ms-excel");
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        OutputStream outputStream = null;
        try {
            if (request.getHeader("User-Agent").toLowerCase().indexOf("firefox") > 0) {
                context.setFileName(new String(context.getFileName().getBytes(StandardCharsets.UTF_8), "ISO8859-1"));
            } else {
                context.setFileName(URLEncoder.encode(context.getFileName(), "UTF-8"));
            }
            response.setHeader("Content-disposition", "attachment;filename=" + context.getFileName() + (context.getExcelType() == ExcelType.XLS ? ".xls" : ".xlsx"));
            outputStream = response.getOutputStream();
            context.getWorkbook().write(outputStream);
        }
        catch (IOException e) {
            throw new ExcelResolverException("Excel cache data flush failure, " + e.getMessage());
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
                if (context.getWorkbook() != null) {
                    context.getWorkbook().close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void flushToLocal(String path, ExcelWriterContext context) {
        OutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream((path.endsWith("/") ? path : path + "/") + context.getFileName() + (context.getExcelType() == ExcelType.XLS ? ".xls" : ".xlsx"));
            context.getWorkbook().write(fileOutputStream);
        }
        catch (IOException e) {
            throw new ExcelResolverException("Excel cache data flush failure, " + e.getMessage());
        }
        finally {
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.flush();
                    ((FileOutputStream)fileOutputStream).close();
                }
                if (context.getWorkbook() != null) {
                    context.getWorkbook().close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

