/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.write.resolver;

import cn.gjing.tools.excel.metadata.ExcelFieldProperty;
import cn.gjing.tools.excel.metadata.ExecType;
import cn.gjing.tools.excel.metadata.aware.ExcelWorkbookAware;
import cn.gjing.tools.excel.metadata.aware.ExcelWriteContextAware;
import cn.gjing.tools.excel.metadata.listener.DefaultExcelStyleListener;
import cn.gjing.tools.excel.metadata.listener.DefaultMultiHeadListener;
import cn.gjing.tools.excel.metadata.listener.ExcelWriteListener;
import cn.gjing.tools.excel.write.BigTitle;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.resolver.ExcelBaseWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.util.StringUtils;

public final class ExcelSimpleWriter
extends ExcelBaseWriter {
    public ExcelSimpleWriter(ExcelWriterContext context, int windowSize, HttpServletResponse response, boolean initDefaultStyle) {
        super(context, windowSize, response, initDefaultStyle, ExecType.SIMPLE);
    }

    @Override
    protected void initStyle() {
        this.addListener(new DefaultExcelStyleListener());
    }

    public ExcelSimpleWriter head(List<String[]> headNames) {
        if (headNames != null && !headNames.isEmpty()) {
            this.context.setHeaderSeries(headNames.get(0).length);
            ArrayList<ExcelFieldProperty> properties = new ArrayList<ExcelFieldProperty>();
            for (String[] headName : headNames) {
                properties.add(ExcelFieldProperty.builder().value(headName).build());
            }
            this.context.setFieldProperties(properties);
        }
        return this;
    }

    public ExcelSimpleWriter head2(List<ExcelFieldProperty> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.context.setFieldProperties(properties);
            this.context.setHeaderSeries(properties.get(0).getValue().length);
        }
        return this;
    }

    public ExcelSimpleWriter headHeight(short rowHeight) {
        this.context.setHeaderHeight(rowHeight);
        return this;
    }

    public ExcelSimpleWriter bodyHeight(short rowHeight) {
        this.context.setBodyHeight(rowHeight);
        return this;
    }

    public ExcelSimpleWriter writeTitle(BigTitle bigTitle) {
        this.getClass();
        return this.writeTitle(bigTitle, "Sheet1");
    }

    public ExcelSimpleWriter writeTitle(BigTitle bigTitle, String sheetName) {
        if (bigTitle != null) {
            this.createSheet(sheetName);
            if (bigTitle.getLastCol() < 1) {
                bigTitle.setLastCol(this.context.getFieldProperties().size() - 1);
            }
            this.writerResolver.writeTitle(bigTitle);
        }
        return this;
    }

    public ExcelSimpleWriter write(List<List<Object>> data) {
        this.getClass();
        return this.write(data, "Sheet1", true);
    }

    public ExcelSimpleWriter write(List<List<Object>> data, String sheetName) {
        return this.write(data, sheetName, true);
    }

    public ExcelSimpleWriter write(List<List<Object>> data, boolean needHead) {
        this.getClass();
        return this.write(data, "Sheet1", needHead);
    }

    public ExcelSimpleWriter write(List<List<Object>> data, String sheetName, boolean needHead) {
        this.createSheet(sheetName);
        if (data == null) {
            this.context.setTemplate(true);
            this.writerResolver.writeHead(needHead, null);
        } else {
            this.writerResolver.writeHead(needHead, null).write(data);
        }
        return this;
    }

    public ExcelSimpleWriter multiHead(boolean enable) {
        this.context.setMultiHead(enable);
        if (enable) {
            return this.addListener(new DefaultMultiHeadListener());
        }
        return this;
    }

    public ExcelSimpleWriter multiHead() {
        return this.multiHead(true);
    }

    public ExcelSimpleWriter addListener(ExcelWriteListener listener) {
        this.context.addListener(listener);
        if (listener instanceof ExcelWriteContextAware) {
            ((ExcelWriteContextAware)((Object)listener)).setContext(this.context);
        }
        if (listener instanceof ExcelWorkbookAware) {
            ((ExcelWorkbookAware)((Object)listener)).setWorkbook(this.context.getWorkbook());
        }
        return this;
    }

    public ExcelSimpleWriter addListener(List<? extends ExcelWriteListener> listeners) {
        if (listeners != null) {
            listeners.forEach(this::addListener);
        }
        return this;
    }

    public ExcelSimpleWriter bind(String key) {
        if (StringUtils.hasLength((String)key)) {
            this.context.setUniqueKey(key);
            this.context.setBind(true);
        }
        return this;
    }

    public ExcelSimpleWriter unbind() {
        this.context.setBind(false);
        return this;
    }
}

