/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.write.resolver;

import cn.gjing.tools.excel.metadata.ExecType;
import cn.gjing.tools.excel.util.ListenerChain;
import cn.gjing.tools.excel.util.ParamUtils;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.resolver.core.ExcelWriteXlsResolver;
import cn.gjing.tools.excel.write.resolver.core.ExcelWriteXlsxResolver;
import cn.gjing.tools.excel.write.resolver.core.ExcelWriterResolver;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public abstract class ExcelBaseWriter {
    protected ExcelWriterContext context;
    protected HttpServletResponse response;
    protected ExcelWriterResolver writerResolver;
    protected final String defaultSheetName = "Sheet1";

    protected ExcelBaseWriter(ExcelWriterContext context, int windowSize, HttpServletResponse response, boolean initDefaultStyle, ExecType type) {
        this.response = response;
        this.context = context;
        this.chooseResolver(context, windowSize, type);
        if (initDefaultStyle) {
            this.initStyle();
        }
    }

    protected abstract void initStyle();

    protected void chooseResolver(ExcelWriterContext context, int windowSize, ExecType execType) {
        switch (this.context.getExcelType()) {
            case XLS: {
                context.setWorkbook((Workbook)new HSSFWorkbook());
                this.writerResolver = new ExcelWriteXlsResolver(context, execType);
                break;
            }
            case XLSX: {
                context.setWorkbook((Workbook)new SXSSFWorkbook(windowSize));
                this.writerResolver = new ExcelWriteXlsxResolver(context, execType);
                break;
            }
        }
    }

    public void flush() {
        this.processBind();
        if (ListenerChain.doWorkbookFlushBefore(this.context.getListenerCache(), this.context.getWorkbook())) {
            this.writerResolver.flush(this.response, this.context);
            if (this.context.getWorkbook() instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)this.context.getWorkbook()).dispose();
            }
        }
    }

    public void flushToLocal(String path) {
        this.processBind();
        if (ListenerChain.doWorkbookFlushBefore(this.context.getListenerCache(), this.context.getWorkbook())) {
            this.writerResolver.flushToLocal(path, this.context);
            if (this.context.getWorkbook() instanceof SXSSFWorkbook) {
                ((SXSSFWorkbook)this.context.getWorkbook()).dispose();
            }
        }
    }

    public void createSheet(String sheetName) {
        Sheet sheet = this.context.getWorkbook().getSheet(sheetName);
        if (sheet != null) {
            this.context.setSheet(sheet);
            return;
        }
        sheet = this.context.getWorkbook().createSheet(sheetName);
        this.context.setSheet(sheet);
        ListenerChain.doCompleteSheet(this.context.getListenerCache(), sheet);
    }

    private void processBind() {
        if (!this.context.isBind()) {
            return;
        }
        String unqSheetName = "excelUnqSheet";
        Sheet sheet = this.context.getWorkbook().createSheet(unqSheetName);
        sheet.protectSheet(UUID.randomUUID().toString().replaceAll("-", ""));
        Row row = sheet.createRow(0);
        row.createCell(0).setCellValue(ParamUtils.encodeMd5(this.context.getUniqueKey()));
        this.context.getWorkbook().setSheetHidden(this.context.getWorkbook().getSheetIndex(sheet), true);
    }
}

