/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.read.resolver.core;

import cn.gjing.tools.excel.metadata.ExecType;
import cn.gjing.tools.excel.metadata.RowType;
import cn.gjing.tools.excel.read.ExcelReaderContext;
import cn.gjing.tools.excel.read.resolver.core.ExcelBaseReadExecutor;
import cn.gjing.tools.excel.util.ListenerChain;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

class ExcelSimpleReadExecutor<R>
extends ExcelBaseReadExecutor<R> {
    public ExcelSimpleReadExecutor(ExcelReaderContext<R> context) {
        super(context);
    }

    @Override
    public void read(int headerIndex, String sheetName) {
        super.checkSheet(sheetName);
        ListenerChain.doReadBefore(this.context.getListenerCache());
        boolean continueRead = true;
        for (Row row : this.context.getSheet()) {
            if (!continueRead) break;
            if (row.getRowNum() < headerIndex) {
                continueRead = super.readHeadBefore(this.context.getListenerCache(), row);
                continue;
            }
            if (row.getRowNum() == headerIndex) {
                continueRead = super.readHead(this.context.getListenerCache(), row);
                continue;
            }
            int size = this.context.getHeadNames().size();
            for (int i = 0; i < size; ++i) {
                String head = this.context.getHeadNames().get(i);
                if ("ignored".equals(head)) continue;
                Cell cell = row.getCell(i);
                if (cell != null) {
                    Object value = this.getValue(null, cell, null, head, false, false, RowType.BODY, ExecType.SIMPLE);
                    ListenerChain.doReadCell(this.context.getListenerCache(), value, cell, row.getRowNum(), i, RowType.BODY);
                    continue;
                }
                ListenerChain.doReadCell(this.context.getListenerCache(), null, null, row.getRowNum(), i, RowType.BODY);
            }
            continueRead = ListenerChain.doReadRow(this.context.getListenerCache(), null, row, RowType.BODY);
        }
        ListenerChain.doReadFinish(this.context.getListenerCache());
    }
}

