/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.read.resolver.core;

import cn.gjing.tools.excel.ExcelField;
import cn.gjing.tools.excel.convert.DataConvert;
import cn.gjing.tools.excel.convert.DefaultDataConvert;
import cn.gjing.tools.excel.convert.ExcelDataConvert;
import cn.gjing.tools.excel.exception.ExcelAssertException;
import cn.gjing.tools.excel.exception.ExcelInitException;
import cn.gjing.tools.excel.exception.ExcelTemplateException;
import cn.gjing.tools.excel.metadata.ELMeta;
import cn.gjing.tools.excel.metadata.ExecType;
import cn.gjing.tools.excel.metadata.RowType;
import cn.gjing.tools.excel.metadata.listener.ExcelListener;
import cn.gjing.tools.excel.read.ExcelReaderContext;
import cn.gjing.tools.excel.read.resolver.core.ExcelBaseReadExecutor;
import cn.gjing.tools.excel.read.valid.ExcelAssert;
import cn.gjing.tools.excel.util.BeanUtils;
import cn.gjing.tools.excel.util.JsonUtils;
import cn.gjing.tools.excel.util.ListenerChain;
import cn.gjing.tools.excel.util.ParamUtils;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;

class ExcelBindReadExecutor<R>
extends ExcelBaseReadExecutor<R> {
    private final Map<Class<? extends DataConvert<?>>, DataConvert<?>> dataConvertMap = new HashMap(16);

    public ExcelBindReadExecutor(ExcelReaderContext<R> context) {
        super(context);
        this.dataConvertMap.put(DefaultDataConvert.class, new DefaultDataConvert());
    }

    @Override
    public void read(int headerIndex, String sheetName) {
        if (this.context.isCheckTemplate()) {
            String key = "excelUnqSheet";
            if (this.context.getWorkbook().getSheetIndex(key) == -1) {
                throw new ExcelTemplateException();
            }
            Iterator iterator = this.context.getWorkbook().getSheet(key).iterator();
            if (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                if (!ParamUtils.equals(ParamUtils.encodeMd5(this.context.getUniqueKey()), row.getCell(0).getStringCellValue(), false)) {
                    throw new ExcelTemplateException();
                }
            }
            this.context.setCheckTemplate(false);
        }
        super.checkSheet(sheetName);
        this.reader(headerIndex, this.context.getResultReadListener() == null ? null : new ArrayList(), this.context.getListenerCache(), (EvaluationContext)new StandardEvaluationContext());
    }

    private void reader(int headerIndex, List<R> dataList, List<ExcelListener> rowReadListeners, EvaluationContext context) {
        this.saveCurrentRowObj = true;
        boolean continueRead = true;
        ListenerChain.doReadBefore(rowReadListeners);
        for (Row row : this.context.getSheet()) {
            Object r;
            if (!continueRead) break;
            if (row.getRowNum() < headerIndex) {
                continueRead = super.readHeadBefore(rowReadListeners, row);
                continue;
            }
            if (row.getRowNum() == headerIndex) {
                continueRead = super.readHead(rowReadListeners, row);
                continue;
            }
            try {
                r = this.context.getExcelClass().newInstance();
                context.setVariable(this.context.getExcelClass().getSimpleName(), r);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new ExcelInitException("Excel entity init failure, " + e.getMessage());
            }
            int size = this.context.getHeadNames().size();
            for (int c = 0; c < size && this.saveCurrentRowObj.booleanValue(); ++c) {
                Object value;
                String head = this.context.getHeadNames().get(c);
                if ("ignored".equals(head)) continue;
                Field field = this.context.getExcelFieldMap().get(head);
                if (field == null) {
                    field = this.context.getExcelFieldMap().get(head + ParamUtils.numberToEn(c));
                }
                if (field == null) continue;
                ExcelField excelField = field.getAnnotation(ExcelField.class);
                Cell valueCell = row.getCell(c);
                if (valueCell != null) {
                    value = super.getValue(r, valueCell, field, head, excelField.trim(), excelField.required(), RowType.BODY, ExecType.BIND);
                    context.setVariable(field.getName(), value);
                    this.assertValue(context, row, c, field, excelField);
                    value = this.convert(r, value, context, field.getAnnotation(ExcelDataConvert.class), this.createDataConvert(field, excelField));
                    value = ListenerChain.doReadCell(rowReadListeners, value, valueCell, row.getRowNum(), c, RowType.BODY);
                } else {
                    if (excelField.required()) {
                        this.saveCurrentRowObj = ListenerChain.doReadEmpty(this.context.getListenerCache(), r, head, null);
                    }
                    context.setVariable(field.getName(), null);
                    this.assertValue(context, row, c, field, excelField);
                    value = this.convert(r, null, context, field.getAnnotation(ExcelDataConvert.class), this.createDataConvert(field, excelField));
                    value = ListenerChain.doReadCell(rowReadListeners, value, null, row.getRowNum(), c, RowType.BODY);
                }
                if (value != null) {
                    this.setValue(r, field, value);
                }
                context.setVariable(field.getName(), value);
            }
            if (!this.saveCurrentRowObj.booleanValue()) continue;
            continueRead = ListenerChain.doReadRow(rowReadListeners, r, row, RowType.BODY);
            if (dataList == null) continue;
            dataList.add(r);
        }
        ListenerChain.doReadFinish(rowReadListeners);
        if (this.context.getResultReadListener() != null) {
            this.context.getResultReadListener().notify(dataList);
        }
    }

    private Object convert(R entity, Object value, EvaluationContext context, ExcelDataConvert excelDataConvert, DataConvert<?> dataConvert) {
        if (excelDataConvert != null && !"".equals(excelDataConvert.expr2())) {
            return ELMeta.PARSER.getParser().parseExpression(excelDataConvert.expr2()).getValue(context);
        }
        return dataConvert.toEntityAttribute(JsonUtils.toObj(JsonUtils.toJson(entity), entity.getClass()), value);
    }

    private DataConvert<?> createDataConvert(Field field, ExcelField excelField) {
        DataConvert<?> dataConvert = this.dataConvertMap.get(excelField.convert());
        if (dataConvert == null) {
            try {
                dataConvert = excelField.convert().newInstance();
                this.dataConvertMap.put(excelField.convert(), dataConvert);
            }
            catch (Exception e) {
                throw new ExcelInitException("Init specified excel header data converter failure " + field.getName() + ", " + e.getMessage());
            }
        }
        return dataConvert;
    }

    private void setValue(R o, Field field, Object value) {
        try {
            BeanUtils.setFieldValue(o, field, value);
        }
        catch (RuntimeException e) {
            if (field.getType() == LocalDate.class) {
                BeanUtils.setFieldValue(o, field, LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault()).toLocalDate());
                return;
            }
            if (field.getType() == LocalDateTime.class) {
                BeanUtils.setFieldValue(o, field, LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault()));
                return;
            }
            throw new IllegalArgumentException("Unsupported data type, the current cell value type is " + value.getClass().getTypeName() + ", but " + field.getName() + " is " + field.getType().getTypeName());
        }
    }

    private void assertValue(EvaluationContext context, Row row, int c, Field field, ExcelField excelField) {
        Boolean test;
        ExcelAssert excelAssert = field.getAnnotation(ExcelAssert.class);
        if (excelAssert != null && (test = (Boolean)ELMeta.PARSER.getParser().parseExpression(excelAssert.expr()).getValue(context, Boolean.class)) != null && !test.booleanValue()) {
            throw new ExcelAssertException(excelAssert.message(), excelField, field, row.getRowNum(), c);
        }
    }
}

