/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.read.resolver.core;

import cn.gjing.tools.excel.exception.ExcelResolverException;
import cn.gjing.tools.excel.metadata.ExecType;
import cn.gjing.tools.excel.metadata.RowType;
import cn.gjing.tools.excel.metadata.listener.ExcelListener;
import cn.gjing.tools.excel.read.ExcelReaderContext;
import cn.gjing.tools.excel.util.JsonUtils;
import cn.gjing.tools.excel.util.ListenerChain;
import cn.gjing.tools.excel.util.ParamUtils;
import com.monitorjbl.xlsx.impl.StreamingWorkbook;
import java.lang.reflect.Field;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public abstract class ExcelBaseReadExecutor<R> {
    protected final ExcelReaderContext<R> context;
    protected Boolean saveCurrentRowObj;

    public ExcelBaseReadExecutor(ExcelReaderContext<R> context) {
        this.context = context;
    }

    public abstract void read(int var1, String var2);

    protected boolean readHead(List<ExcelListener> rowReadListeners, Row row) {
        for (Cell cell : row) {
            String value = cell.getStringCellValue();
            if (ParamUtils.contains(this.context.getIgnores(), value)) {
                value = "ignored";
            }
            this.context.getHeadNames().add(String.valueOf(ListenerChain.doReadCell(rowReadListeners, value, cell, row.getRowNum(), cell.getColumnIndex(), RowType.HEAD)));
        }
        return ListenerChain.doReadRow(rowReadListeners, null, row, RowType.HEAD);
    }

    protected boolean readHeadBefore(List<ExcelListener> rowReadListeners, Row row) {
        if (this.context.isHeadBefore()) {
            for (Cell cell : row) {
                Object value = this.getValue(null, cell, null, null, false, false, RowType.OTHER, ExecType.SIMPLE);
                ListenerChain.doReadCell(rowReadListeners, value, cell, row.getRowNum(), cell.getColumnIndex(), RowType.OTHER);
            }
            return ListenerChain.doReadRow(rowReadListeners, null, row, RowType.OTHER);
        }
        return true;
    }

    protected void checkSheet(String sheetName) {
        if (this.context.getWorkbook() instanceof StreamingWorkbook) {
            try {
                this.context.setSheet(this.context.getWorkbook().getSheet(sheetName));
            }
            catch (Exception e) {
                throw new ExcelResolverException("The " + sheetName + " is not found in the workbook");
            }
        } else {
            Sheet sheet = this.context.getWorkbook().getSheet(sheetName);
            if (sheet == null) {
                throw new ExcelResolverException("The " + sheetName + " is not found in the workbook");
            }
            this.context.setSheet(sheet);
        }
    }

    protected Object getValue(R r, Cell cell, Field field, String header, boolean trim, boolean required, RowType rowType, ExecType execType) {
        switch (cell.getCellType()) {
            case _NONE: 
            case BLANK: 
            case ERROR: {
                if (rowType != RowType.BODY || !required) break;
                this.saveCurrentRowObj = ListenerChain.doReadEmpty(this.context.getListenerCache(), r, header, cell);
                break;
            }
            case BOOLEAN: {
                return cell.getBooleanCellValue();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return cell.getDateCellValue();
                }
                if (execType == ExecType.BIND) {
                    return rowType == RowType.BODY ? JsonUtils.toObj(JsonUtils.toJson(cell.getNumericCellValue()), field.getType()) : Double.valueOf(cell.getNumericCellValue());
                }
                return cell.getNumericCellValue();
            }
            case FORMULA: {
                if (execType == ExecType.BIND) {
                    return rowType == RowType.BODY ? JsonUtils.toObj(JsonUtils.toJson(cell.getStringCellValue()), field.getType()) : cell.getStringCellValue();
                }
                return cell.getStringCellValue();
            }
            default: {
                return trim ? cell.getStringCellValue().trim() : cell.getStringCellValue();
            }
        }
        return null;
    }
}

