/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.metadata.listener;

import cn.gjing.tools.excel.metadata.RowType;
import cn.gjing.tools.excel.metadata.aware.ExcelWriteContextAware;
import cn.gjing.tools.excel.util.ExcelUtils;
import cn.gjing.tools.excel.write.ExcelWriterContext;
import cn.gjing.tools.excel.write.listener.ExcelRowWriteListener;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class DefaultMultiHeadListener
implements ExcelRowWriteListener,
ExcelWriteContextAware {
    private ExcelWriterContext writerContext;

    @Override
    public void setContext(ExcelWriterContext writerContext) {
        this.writerContext = writerContext;
    }

    @Override
    public void completeRow(Sheet sheet, Row row, Object obj, int index, RowType rowType) {
        if (rowType != RowType.HEAD) {
            return;
        }
        if (index == 0) {
            int startCol = 0;
            int endCol = 0;
            int startRow = row.getRowNum();
            int endRow = row.getRowNum();
            int nextHeadIndex = 1;
            for (int i = 0; i < this.writerContext.getHeaderSeries(); ++i) {
                int level = i;
                int len = this.writerContext.getFieldProperties().size();
                for (int j = 0; j < len; ++j) {
                    if (nextHeadIndex - j < 1) {
                        ++nextHeadIndex;
                    }
                    if (ExcelUtils.isMerge(sheet, startRow, j)) {
                        startCol = nextHeadIndex;
                        endCol = nextHeadIndex;
                        continue;
                    }
                    while (len > nextHeadIndex && this.writerContext.getFieldProperties().get(nextHeadIndex).getValue()[level].equals(this.writerContext.getFieldProperties().get(nextHeadIndex - 1).getValue()[level])) {
                        j = endCol = nextHeadIndex++;
                    }
                    while (this.writerContext.getHeaderSeries() - 1 > level && this.writerContext.getFieldProperties().get(j).getValue()[level].equals(this.writerContext.getFieldProperties().get(j).getValue()[level + 1])) {
                        ++endRow;
                        ++level;
                    }
                    if (startCol != endCol || startRow != endRow) {
                        ExcelUtils.merge(this.writerContext.getSheet(), startCol, endCol, startRow, endRow);
                        level = i;
                        startCol = nextHeadIndex;
                        endCol = nextHeadIndex;
                        endRow = startRow;
                        continue;
                    }
                    startCol = nextHeadIndex;
                    endCol = nextHeadIndex;
                }
                startCol = 0;
                endCol = 0;
                endRow = ++startRow;
                nextHeadIndex = 1;
            }
        }
    }
}

