/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.metadata.listener;

import cn.gjing.tools.excel.util.ParamUtils;
import cn.gjing.tools.excel.write.listener.ExcelCascadingDropdownBoxListener;
import cn.gjing.tools.excel.write.valid.ExcelDropdownBox;
import java.lang.reflect.Field;
import java.util.Map;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public final class DefaultCascadingDropdownBoxListener
implements ExcelCascadingDropdownBoxListener {
    private final Map<String, String[]> boxValues;
    private boolean init = true;

    public DefaultCascadingDropdownBoxListener(Map<String, String[]> boxValues) {
        this.boxValues = boxValues;
    }

    @Override
    public void addCascadingDropdownBox(ExcelDropdownBox excelDropdownBox, Workbook workbook, Sheet sheet, int firstRow, int lastRow, int colIndex, Field field) {
        if (this.init) {
            Sheet explicitSheet = workbook.getSheet("subsetSheet");
            if (explicitSheet == null) {
                explicitSheet = workbook.createSheet("subsetSheet");
                workbook.setSheetHidden(workbook.getSheetIndex("subsetSheet"), true);
            }
            for (Map.Entry<String, String[]> valueMap : this.boxValues.entrySet()) {
                Name name = workbook.getName(valueMap.getKey());
                if (name != null) continue;
                int rowIndex = explicitSheet.getPhysicalNumberOfRows();
                Row subsetSheetRow = explicitSheet.createRow(rowIndex);
                subsetSheetRow.createCell(0).setCellValue(valueMap.getKey());
                int length = valueMap.getValue().length;
                for (int i = 0; i < length; ++i) {
                    subsetSheetRow.createCell(i + 1).setCellValue(valueMap.getValue()[i]);
                }
                String formula = ParamUtils.createFormulaX(1, rowIndex + 1, valueMap.getValue().length);
                name = workbook.createName();
                name.setNameName(valueMap.getKey());
                name.setRefersToFormula("subsetSheet!" + formula);
            }
            this.init = false;
        }
        char parentIndex = (char)(65 + Integer.parseInt(excelDropdownBox.link()));
        DataValidationHelper helper = sheet.getDataValidationHelper();
        for (int i = firstRow; i <= lastRow; ++i) {
            String forMuaString = "INDIRECT($" + parentIndex + "$" + (i + 1) + ")";
            DataValidationConstraint constraint = helper.createFormulaListConstraint(forMuaString);
            CellRangeAddressList regions = new CellRangeAddressList(i, i, colIndex, colIndex);
            DataValidation dataValidation = helper.createValidation(constraint, regions);
            dataValidation.setErrorStyle(excelDropdownBox.rank().getRank());
            dataValidation.createErrorBox(excelDropdownBox.errorTitle(), excelDropdownBox.errorContent());
            dataValidation.createErrorBox(excelDropdownBox.errorTitle(), excelDropdownBox.errorContent());
            dataValidation.setShowErrorBox(excelDropdownBox.showErrorBox());
            sheet.addValidationData(dataValidation);
        }
    }
}

