/*
 * Decompiled with CFR 0.152.
 */
package cn.gjing.tools.excel.driven;

import cn.gjing.tools.excel.exception.ExcelInitException;
import cn.gjing.tools.excel.exception.ExcelTemplateException;
import cn.gjing.tools.excel.metadata.ExcelType;
import cn.gjing.tools.excel.metadata.listener.ExcelReadListener;
import cn.gjing.tools.excel.read.listener.ExcelResultReadListener;
import cn.gjing.tools.excel.util.ParamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.web.multipart.MultipartFile;

public class ExcelReadWrapper<R> {
    private final Class<R> mapping;
    private List<ExcelReadListener> readListeners;
    private ExcelResultReadListener<R> resultReadListener;
    private InputStream inputStream;
    private String[] ignores;
    private String unqKey;
    private ExcelType excelType;

    private ExcelReadWrapper(Class<R> mapping) {
        this.mapping = mapping;
    }

    public static <R> ExcelReadWrapper<R> build(Class<R> mapping) {
        return new ExcelReadWrapper<R>(mapping);
    }

    public ExcelReadWrapper<R> data(MultipartFile file) {
        try {
            ExcelType excelType = ParamUtils.getExcelType(file.getOriginalFilename());
            if (excelType == null) {
                throw new ExcelTemplateException("File type does not belong to Excel");
            }
            this.inputStream = file.getInputStream();
            this.excelType = excelType;
        }
        catch (IOException e) {
            throw new ExcelInitException("Initialize read wrapper error," + e.getMessage());
        }
        return this;
    }

    public ExcelReadWrapper<R> data(File file) {
        try {
            ExcelType excelType = ParamUtils.getExcelType(file.getName());
            if (excelType == null) {
                throw new ExcelTemplateException("File type does not belong to Excel");
            }
            this.inputStream = new FileInputStream(file);
            this.excelType = excelType;
        }
        catch (FileNotFoundException e) {
            throw new ExcelInitException("Initialize read wrapper error," + e.getMessage());
        }
        return this;
    }

    public ExcelReadWrapper<R> data(InputStream inputStream) {
        this.inputStream = inputStream;
        this.excelType = ExcelType.XLS;
        return this;
    }

    public ExcelReadWrapper<R> data(InputStream inputStream, ExcelType excelType) {
        this.inputStream = inputStream;
        this.excelType = excelType;
        return this;
    }

    public ExcelReadWrapper<R> listener(ExcelReadListener readListener) {
        if (this.readListeners == null) {
            this.readListeners = new ArrayList<ExcelReadListener>();
        }
        this.readListeners.add(readListener);
        return this;
    }

    public ExcelReadWrapper<R> listener(List<ExcelReadListener> readListeners) {
        if (this.readListeners == null) {
            this.readListeners = new ArrayList<ExcelReadListener>();
        }
        this.readListeners.addAll(readListeners);
        return this;
    }

    public ExcelReadWrapper<R> subscribe(ExcelResultReadListener<R> resultListener) {
        this.resultReadListener = resultListener;
        return this;
    }

    public ExcelReadWrapper<R> ignores(String ... ignores) {
        this.ignores = ignores;
        return this;
    }

    public ExcelReadWrapper<R> check(String key) {
        this.unqKey = key;
        return this;
    }

    public Class<R> getMapping() {
        return this.mapping;
    }

    public List<ExcelReadListener> getReadListeners() {
        return this.readListeners;
    }

    public ExcelResultReadListener<R> getResultReadListener() {
        return this.resultReadListener;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public String[] getIgnores() {
        return this.ignores;
    }

    public String getUnqKey() {
        return this.unqKey;
    }

    public ExcelType getExcelType() {
        return this.excelType;
    }

    public String toString() {
        return "ExcelReadWrapper(mapping=" + this.getMapping() + ", readListeners=" + this.getReadListeners() + ", resultReadListener=" + this.getResultReadListener() + ", inputStream=" + this.getInputStream() + ", ignores=" + Arrays.deepToString(this.getIgnores()) + ", unqKey=" + this.getUnqKey() + ", excelType=" + (Object)((Object)this.getExcelType()) + ")";
    }
}

